<?php


if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_ccx_plugin_settings' );
function dvs_ccx_plugin_settings() {
	register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_enable' );
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_account' );	
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_origin' );
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_type' );     
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_handling' );           
	register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_consignee' );
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_product' );	      
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_remarks' );
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_product_check' );     
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_sku_check' );
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_notes_check' );
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_weight_check' );    
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_pieces_check' );    
    register_setting( 'dvs-ccx-settings-group', 'dvs_ccx_cod_check' );                              
}


//Courier settings input fields
function dvs_ccx_api_page() { ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    jQuery(document).ready(function($) {
        $('#dvs_ccx_origin').select2();
    });
</script>
    
<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-ccx-settings-group' );
	do_settings_sections( 'dvs-ccx-settings-group' );
	$dvs_ccx_origin = get_option('dvs_ccx_origin');
	$dvs_ccx_type = get_option('dvs_ccx_type');
	$dvs_ccx_handling = get_option('dvs_ccx_handling');
	$dvs_ccx_consignee = get_option('dvs_ccx_consignee');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/ccx-label-logo.png'; ?>" height="50px">
    <h2>Courierx Settings</h2>
    <table class="form-table">

        <tr>
        <th scope="row">Enable CourierX API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_ccx_enable" value="1" ' . checked( 1, get_option( 'dvs_ccx_enable' ), false ) . ' />';?>
        </td>
        </tr> 

        <tr>
        <th scope="row">Account ID</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_ccx_account" value="<?php echo esc_attr( get_option('dvs_ccx_account') ); ?>" required /></td>
        </tr>          

        <tr>
        <th scope="row">Shipper Origin</th>
        <td>
        <select id="dvs_ccx_origin" name="dvs_ccx_origin" required>
            <?php 
            $pickup_url = get_option( 'dvs_url' )."/woo/assets/ccx-city.json";
            $pickup_result = wp_remote_get($pickup_url);
            $pickup_result = json_decode( wp_remote_retrieve_body( $pickup_result ), true );
            foreach ($pickup_result as $pickup_city) { ?>
                <option value="<?php echo $pickup_city['CityId'] ?>" <?php selected($dvs_ccx_origin, $pickup_city['CityId']); ?>><?php echo $pickup_city['CityName'] ?></option>
            <?php } ?>
        </select>
        <td>        
        </tr>
 
        <tr>
        <th scope="row">Shipment Type</th>
        <td>
            <select id="dvs_ccx_type" name="dvs_ccx_type" required>
                <option value="2" <?php selected($dvs_ccx_type,'2'); ?>>COD</option>
            	<option value="1" <?php selected($dvs_ccx_type,'1'); ?>>Non-COD</option>
                <option value="3" <?php selected($dvs_ccx_type,'3'); ?>>Detain</option>
                <option value="4" <?php selected($dvs_ccx_type,'4'); ?>>Overland</option>
                <option value="5" <?php selected($dvs_ccx_type,'5'); ?>>Same Day</option>
                <option value="6" <?php selected($dvs_ccx_type,'6'); ?>>Door to Door</option>
                <option value="7" <?php selected($dvs_ccx_type,'7'); ?>>Airport To Airport</option>
                <option value="8" <?php selected($dvs_ccx_type,'8'); ?>>To Pay</option>
                <option value="9" <?php selected($dvs_ccx_type,'9'); ?>>Detained COD</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Shipment Handling</th>
        <td>
            <select id="dvs_ccx_handling" name="dvs_ccx_handling" required>
            	<option value="Yes" <?php selected($dvs_ccx_handling,'Yes'); ?>>Fragile</option>
            </select>
        <td>        
        </tr>        

        <tr>
        <th scope="row">Consginee Details</th>
        <td>
            <select id="dvs_ccx_consignee" name="dvs_ccx_consignee" required>
            <option value="Billing Details" <?php selected($dvs_ccx_consignee,'Billing Details'); ?>>Billing Details</option>
            <option value="Shipping Details" <?php selected($dvs_ccx_consignee,'Shipping Details'); ?>>Shipping Details</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Default Remarks</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_ccx_remarks" value="<?php echo esc_attr( get_option('dvs_ccx_remarks') ); ?>" required /></td>
        </tr>  

        <tr>
        <th scope="row">Default Product</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_ccx_product" value="<?php echo esc_attr( get_option('dvs_ccx_product') ); ?>" /></td>
        </tr>  

        <tr>
        <th scope="row">Print Item Name in Label</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_ccx_product_check" value="1" ' . checked( 1, get_option( 'dvs_ccx_product_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Print SKU Name in Label</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_ccx_sku_check" value="1" ' . checked( 1, get_option( 'dvs_ccx_sku_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Print Order Notes in Remarks</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_ccx_notes_check" value="1" ' . checked( 1, get_option( 'dvs_ccx_notes_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Auto Calculate Weight</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_ccx_weight_check" value="1" ' . checked( 1, get_option( 'dvs_ccx_weight_check' ), false ) . ' />';?>
        </td>
        </tr>               

        <tr>
        <th scope="row">Auto Calculate Pieces</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_ccx_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_ccx_pieces_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Calculate Non-COD as Zero</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_ccx_cod_check" value="1" ' . checked( 1, get_option( 'dvs_ccx_cod_check' ), false ) . ' />';?>
        </td>
        </tr>                        

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<a href="https://www.youtube.com/watch?v=T8ZU9Y8MeTk" target="blank" class="woocommerce-Button button">Video: How to configure CourierX Settings</a>
<br>
<br>
<a href="https://devsol.pk/contact/" target="blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}

function dvs_ccx_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',
        );
    }
        
    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );

    return $orders_data;
}



function dvs_ccx_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'Courierx',
        'dvs_slug' => 'ccx',
        'dvs_type' => get_option( 'dvs_ccx_type' ),
        'dvs_handling' => get_option( 'dvs_ccx_handling' ),
        'dvs_consignee' => get_option( 'dvs_ccx_consignee' ),
        'dvs_remarks' => get_option( 'dvs_ccx_remarks' ),
        'dvs_product' => get_option( 'dvs_ccx_product' ),
        'dvs_product_check' => get_option( 'dvs_ccx_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_ccx_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_ccx_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_ccx_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_ccx_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_ccx_cod_check' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'ccx_bulk_actions',101 );
function ccx_bulk_actions( $bulk_array ) {
    $dvs_ccx_enable = get_option( 'dvs_ccx_enable' );
    if ($dvs_ccx_enable == 1 ) {
        $bulk_array['mark_ccx_orders'] = 'Courierx Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_ccx_bulk_action_handler', 10, 4 );
function dvs_ccx_bulk_action_handler( $redirect, $doaction, $object_ids ) {
	if ( $doaction !== 'mark_ccx_orders' ) {
	    return $redirect;
	}
    $orders_data = [];
    $orders_items = [];
	foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_ccx_orders_data($order_id);

    }
    dvs_ccx_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'ccx_single_order_action', 10, 1 );
function ccx_single_order_action( $actions ) {
    $dvs_ccx_enable = get_option( 'dvs_ccx_enable' );
    if ($dvs_ccx_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['ccx_action'] = __( 'Book at Courierx' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_ccx_action', 'ccx_single_order_booking' );
function ccx_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_ccx_orders_data($order_id);
    dvs_ccx_body_data($orders_data);
    die();
}


add_action( 'init', 'ccx_submit_form' );
function ccx_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'ccx' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "CCX",
				'dvs_ccx_account' => get_option('dvs_ccx_account'),				
				'dvs_ccx_origin'	=>  get_option('dvs_ccx_origin'),				
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  
            $current_order = $order;

            if (!empty($response['CN'])) {
                $order = new WC_Order($order_id);
                $ccx_tracking = $response['CN'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$ccx_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at Courierx with Tracking # ".$ccx_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'Courierx');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $ccx_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $ccx_tracking, 'Courierx');

                $trackings[] = $ccx_tracking;
                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }    

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/ccx-label-logo.png'; ?>" height="50px">    
            <h3>Courierx Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }

            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_ccx = get_option( 'dvs_courier_ccx' ) + $count ;
        update_option('dvs_courier_ccx', $dvs_courier_ccx);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'CCX',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}


