<?php


if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_covered_plugin_settings' );
function dvs_covered_plugin_settings() {
	register_setting( 'dvs-covered-settings-group', 'dvs_covered_enable' );	
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_username' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_password' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_name' ); 
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_phone' ); 
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_email' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_address' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_city' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_type' );     
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_handling' );           
	register_setting( 'dvs-covered-settings-group', 'dvs_covered_consignee' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_product' );	      
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_remarks' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_product_check' );     
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_sku_check' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_notes_check' );
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_pieces_check' );    
    register_setting( 'dvs-covered-settings-group', 'dvs_covered_cod_check' );   

}

//Courier settings input fields
function dvs_covered_api_page() { ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    jQuery(document).ready(function($) {
        $('#dvs_covered_city').select2();
    });
</script>

<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-covered-settings-group' );
	do_settings_sections( 'dvs-covered-settings-group' );
    $dvs_covered_city = get_option('dvs_covered_city');
	$dvs_covered_type = get_option('dvs_covered_type');
	$dvs_covered_handling = get_option('dvs_covered_handling');
	$dvs_covered_consignee = get_option('dvs_covered_consignee');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/covered-label-logo.png'; ?>" height="50px">
    <h2>Covered Logistics Settings</h2>
    <p>Note: Please get your Username and Password from account manager.</p>      
    <table class="form-table">

        <tr>
        <th scope="row">Enable Covered Logistics API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_covered_enable" value="1" ' . checked( 1, get_option( 'dvs_covered_enable' ), false ) . ' />';?>
        </td>
        </tr> 

        <tr>
        <th scope="row">Username</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_covered_username" value="<?php echo esc_attr( get_option('dvs_covered_username') ); ?>" required/></td>
        </tr>
        <tr>
        <th scope="row">Password</th>
        <td><input class="regular-text" placeholder="" type="password" name="dvs_covered_password" value="<?php echo esc_attr( get_option('dvs_covered_password') ); ?>" required /></td>
        </tr>

        <?php

        $dvs_covered_username = get_option('dvs_covered_username');
        $dvs_covered_password = get_option('dvs_covered_password');

        if (!empty($dvs_covered_username) && !empty($dvs_covered_password) ) {

            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://api.covered.pk/api/v1/customer/login',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>'{
                "userId": '.$dvs_covered_username.',
                "password": "'.$dvs_covered_password.'"
            }',
              CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
              ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);

            $result = json_decode($response, true);

            if($result['statusCode'] == '200') { 

                $curl = curl_init();
                curl_setopt_array($curl, array(
                  CURLOPT_URL => 'https://api.covered.pk/api/v1/customer/getCities',
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 30,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'GET',
                ));
                $response = curl_exec($curl);
                curl_close($curl);

                $result = json_decode($response, true);

                if($result['statusCode'] != '200') {
                    echo '<div class="notice notice-error is-dismissible">
                        <p>Error: Unable to get city list</p>
                        <p>'.$response.'</p>
                    </div>';
                    die();
                }

                ?>

                <tr>
                <th scope="row">Shipper Name</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_covered_name" value="<?php echo esc_attr( get_option('dvs_covered_name') ); ?>" required /></td>
                </tr> 
                <tr>
                <th scope="row">Shipper Phone</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_covered_phone" value="<?php echo esc_attr( get_option('dvs_covered_phone') ); ?>" required /></td>
                </tr>
                <tr>
                <th scope="row">Shipper Email</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_covered_email" value="<?php echo esc_attr( get_option('dvs_covered_email') ); ?>" required /></td>
                </tr>

                <tr>
                <th scope="row">Shipper Address</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_covered_address" value="<?php echo esc_attr( get_option('dvs_covered_address') ); ?>" required /></td>
                </tr>	        

                <tr>
                <th scope="row">Shipper City</th>
                <td>
                <select id="dvs_covered_city" name="dvs_covered_city" required>
                    <?php 
                    $cities = $result['data'];
                    asort($cities);
                    foreach($cities as $city) { ?>
                        <option value="<?php echo $city ?>" <?php selected($dvs_covered_city, $city); ?>><?php echo $city ?></option>
                    <?php } ?>
                </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Shipment Type</th>
                <td>
                    <select id="dvs_covered_type" name="dvs_covered_type" required>
                    	<option value="Express" <?php selected($dvs_covered_type,'Express'); ?>>Express</option>
                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Shipment Handling</th>
                <td>
                    <select id="dvs_covered_handling" name="dvs_covered_handling" required>
                    	<option value="Yes" <?php selected($dvs_covered_handling,'Yes'); ?>>Fragile</option>
                    </select>
                <td>        
                </tr>        

                <tr>
                <th scope="row">Consginee Details</th>
                <td>
                    <select id="dvs_covered_consignee" name="dvs_covered_consignee" required>
                    <option value="Billing Details" <?php selected($dvs_covered_consignee,'Billing Details'); ?>>Billing Details</option>
                    <option value="Shipping Details" <?php selected($dvs_covered_consignee,'Shipping Details'); ?>>Shipping Details</option>
                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Default Remarks</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_covered_remarks" value="<?php echo esc_attr( get_option('dvs_covered_remarks') ); ?>" required/></td>
                </tr>  

                <tr>
                <th scope="row">Default Product</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_covered_product" value="<?php echo esc_attr( get_option('dvs_covered_product') ); ?>" /></td>
                </tr>  

                <tr>
                <th scope="row">Print Item Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_covered_product_check" value="1" ' . checked( 1, get_option( 'dvs_covered_product_check' ), false ) . ' />';?>
                </td>
                </tr>

                <tr>
                <th scope="row">Print SKU Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_covered_sku_check" value="1" ' . checked( 1, get_option( 'dvs_covered_sku_check' ), false ) . ' />';?>
                </td>
                </tr>     

                <tr>
                <th scope="row">Print Order Notes in Remarks</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_covered_notes_check" value="1" ' . checked( 1, get_option( 'dvs_covered_notes_check' ), false ) . ' />';?>
                </td>
                </tr>  

                <tr>
                <th scope="row">Auto Calculate Pieces</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_covered_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_covered_pieces_check' ), false ) . ' />';?>
                </td>
                </tr>           

                <tr>
                <th scope="row">Calculate Non-COD as Zero</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_covered_cod_check" value="1" ' . checked( 1, get_option( 'dvs_covered_cod_check' ), false ) . ' />';?>
                </td>
                </tr>

            <?php
                }
                else {
                    echo '<div class="notice notice-error is-dismissible"><p>Error: Invalid Username or Password</p></div>';
                }
            }
        ?>
    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<a href="https://devsol.pk/contact/" target="blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}


function dvs_covered_orders_data($order_id) {
    $order = wc_get_order($order_id);
    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',
        );
    }

    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );

    return $orders_data;
}



function dvs_covered_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'Covered Logistics',
        'dvs_slug' => 'covered',
        'dvs_covered_username' => get_option( 'dvs_covered_username' ),
        'dvs_covered_password' => get_option( 'dvs_covered_password' ),
        'dvs_type' => get_option( 'dvs_covered_type' ),
        'dvs_handling' => get_option( 'dvs_covered_handling' ),
        'dvs_consignee' => get_option( 'dvs_covered_consignee' ),
        'dvs_remarks' => get_option( 'dvs_covered_remarks' ),
        'dvs_product' => get_option( 'dvs_covered_product' ),
        'dvs_product_check' => get_option( 'dvs_covered_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_covered_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_covered_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_covered_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_covered_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_covered_cod_check' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'covered_bulk_actions',101 );
function covered_bulk_actions( $bulk_array ) {
    $dvs_covered_enable = get_option( 'dvs_covered_enable' );
    if ($dvs_covered_enable == 1 ) {
        $bulk_array['mark_covered_orders'] = 'Covered Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_covered_bulk_action_handler', 10, 4 );
function dvs_covered_bulk_action_handler( $redirect, $doaction, $object_ids ) {
    if ( $doaction !== 'mark_covered_orders' ) {
        return $redirect;
    }
    $orders_data = [];
    $orders_items = [];
    foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_covered_orders_data($order_id);

    }
    dvs_covered_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'covered_single_order_action', 10, 1 );
function covered_single_order_action( $actions ) {
    $dvs_covered_enable = get_option( 'dvs_covered_enable' );
    if ($dvs_covered_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['covered_action'] = __( 'Book at Covered Logistics' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_covered_action', 'covered_single_order_booking' );
function covered_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_covered_orders_data($order_id);
    dvs_covered_body_data($orders_data);
    die();
}


add_action( 'init', 'covered_submit_form' );
function covered_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'covered' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "COVERED",
                'dvs_covered_username' => get_option( 'dvs_covered_username' ),
                'dvs_covered_password' => get_option( 'dvs_covered_password' ),
                'dvs_covered_name'  => get_option('dvs_covered_name'),
                'dvs_covered_email' => get_option('dvs_covered_email'),
                'dvs_covered_phone' => get_option('dvs_covered_phone'),
                'dvs_covered_address' => get_option('dvs_covered_address'),
                'dvs_covered_city' => get_option('dvs_covered_city'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  
            $current_order = $order;

            if($response['data']['consigneeNo']) {
                $order = new WC_Order($order_id);
                $covered_tracking = $response['data']['consigneeNo'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$covered_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at Covered Logistics with Tracking # ".$covered_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'Covered Logistics');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $covered_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );


                $dvs_courier_link = 'https://covered.pk';
                update_post_meta( $order->get_id(), '_dvs_courier_link', $dvs_courier_link ); 

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $covered_tracking, 'Covered Logistics');
                $trackings[] = $covered_tracking;
         
                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }   

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/covered-label-logo.png'; ?>" height="50px">    
            <h3>Covered Logistics Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }
            
            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_covered = get_option( 'dvs_courier_covered' ) + $count ;
        update_option('dvs_courier_covered', $dvs_courier_covered);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'covered',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}
