<?php

if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_dodeliver_plugin_settings' );
function dvs_dodeliver_plugin_settings() {
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_enable' );	
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_token' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_pickup' );    
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_type' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_handling' );        
	register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_consignee' );       
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_remarks' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_product' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_product_check' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_pieces_check' );     
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_sku_check' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_notes_check' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_weight_check' );
    register_setting( 'dvs-dodeliver-settings-group', 'dvs_dodeliver_cod_check' );                             
}

//Courier settings input fields
function dvs_dodeliver_api_page() { ?>
<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-dodeliver-settings-group' );
	do_settings_sections( 'dvs-dodeliver-settings-group' ); 
	$dvs_dodeliver_type = get_option('dvs_dodeliver_type');
	$dvs_dodeliver_handling = get_option('dvs_dodeliver_handling');
	$dvs_dodeliver_consignee = get_option('dvs_dodeliver_consignee');
    $dvs_dodeliver_token = get_option('dvs_dodeliver_token');
    $dvs_dodeliver_pickup = get_option('dvs_dodeliver_pickup');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/dodeliver-label-logo.png'; ?>" height="50px">
    <h2>Do Deliver Settings</h2>
    <table class="form-table">

        <tr>
        <th scope="row">Enable Do Deliver API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_dodeliver_enable" value="1" ' . checked( 1, get_option( 'dvs_dodeliver_enable' ), false ) . ' />';?>
        </td>
        </tr>               

        <tr>
        <th scope="row">API Key</th>
        <td><input class="regular-text" placeholder="" type="password" name="dvs_dodeliver_token" value="<?php echo esc_attr( get_option('dvs_dodeliver_token') ); ?>" required/></td>
        </tr>

        <?php

        if(!empty($dvs_dodeliver_token)) {

            $curl = curl_init();
            curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://portal.dodeliver.com.pk/api/pickup/locations?api_key='.$dvs_dodeliver_token,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Accept: application/json'
            ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);

            $pickup_result = json_decode($response, true);

            if (isset($pickup_result['locations'][0]['id'])) {

            ?>        
 
            <tr>
            <th scope="row">Pickup Address</th>
            <td>
                <select id="dvs_dodeliver_pickup" name="dvs_dodeliver_pickup" >
                <?php
                    foreach ($pickup_result['locations'] as $pickup) {
                        if($pickup['id'] == $dvs_dodeliver_pickup)
                            echo "<option value='" . $pickup['id'] . "' selected>" . $pickup['contact_person'] . ' - ' . $pickup['address'] . ' - ' . $pickup['city'] . "</option>";
                        else
                            echo "<option value='" . $pickup['id'] . "'>" . $pickup['contact_person'] . ' - ' . $pickup['address'] . ' - ' . $pickup['city'] ."</option>";
                    }
                ?>
                </select>    
            </td>
            </tr> 

            <tr>
            <th scope="row">Shipment Type</th>
            <td>
                <select id="dvs_dodeliver_type" name="dvs_dodeliver_type" required>
                	<option value="overnight" <?php selected($dvs_dodeliver_type,'overnight'); ?>>Overnight</option>
                </select>
            <td>        
            </tr>

            <tr>
            <th scope="row">Shipment Handling</th>
            <td>
                <select id="dvs_dodeliver_handling" name="dvs_dodeliver_handling" required>
                	<option value="Yes" <?php selected($dvs_dodeliver_handling,'Yes'); ?>>Fragile</option>
                </select>
            <td>        
            </tr>        

            <tr>
            <th scope="row">Consginee Details</th>
            <td>
                <select id="dvs_dodeliver_consignee" name="dvs_dodeliver_consignee" required>
                <option value="Billing Details" <?php selected($dvs_dodeliver_consignee,'Billing Details'); ?>>Billing Details</option>
                <option value="Shipping Details" <?php selected($dvs_dodeliver_consignee,'Shipping Details'); ?>>Shipping Details</option>
                </select>
            <td>        
            </tr>

            <tr>
            <th scope="row">Default Remarks</th>
            <td><input class="regular-text" placeholder="" type="text" name="dvs_dodeliver_remarks" value="<?php echo esc_attr( get_option('dvs_dodeliver_remarks') ); ?>" required /></td>
            </tr>

            <tr>
            <th scope="row">Default Products</th>
            <td><input class="regular-text" placeholder="" type="text" name="dvs_dodeliver_product" value="<?php echo esc_attr( get_option('dvs_dodeliver_product') ); ?>" /></td>
            </tr>    

            <tr>
            <th scope="row">Print Item Name in Label</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_dodeliver_product_check" value="1" ' . checked( 1, get_option( 'dvs_dodeliver_product_check' ), false ) . ' />';?>
            </td>
            </tr>

            <tr>
            <th scope="row">Print SKU Name in Label</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_dodeliver_sku_check" value="1" ' . checked( 1, get_option( 'dvs_dodeliver_sku_check' ), false ) . ' />';?>
            </td>
            </tr>      

            <tr>
            <th scope="row">Print Order Notes in Remarks</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_dodeliver_notes_check" value="1" ' . checked( 1, get_option( 'dvs_dodeliver_notes_check' ), false ) . ' />';?>
            </td>
            </tr>

            <tr>
            <th scope="row">Auto Calculate Weight</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_dodeliver_weight_check" value="1" ' . checked( 1, get_option( 'dvs_dodeliver_weight_check' ), false ) . ' />';?>
            </td>
            </tr>

            <tr>
            <th scope="row">Auto Calculate Pieces</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_dodeliver_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_dodeliver_pieces_check' ), false ) . ' />';?>
            </td>
            </tr>           

            <tr>
            <th scope="row">Calculate Non-COD as Zero</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_dodeliver_cod_check" value="1" ' . checked( 1, get_option( 'dvs_dodeliver_cod_check' ), false ) . ' />';?>
            </td>
            </tr>

            <?php
           }
            else {
                echo '<div class="notice notice-error is-dismissible"><p>Error: Invalid API Token. Please contact support: 03234152099</p></div>';
            }
        }
        ?>

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<a href="https://www.loom.com/share/b88aa427fa5a4e4f9fb13b1bf4337c80" target="blank" class="woocommerce-Button button">Video: How to configure Do Deliver Settings</a>
<br>
<br>
<a href="https://devsol.pk/contact/" target="blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}


function dvs_dodeliver_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',
        );
    }
        
    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );

    return $orders_data;
}



function dvs_dodeliver_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'Do Deliver',
        'dvs_slug' => 'dodeliver',
		'dvs_dodeliver_token' => get_option('dvs_dodeliver_token'),
        'dvs_type' => get_option( 'dvs_dodeliver_type' ),
        'dvs_handling' => get_option( 'dvs_dodeliver_handling' ),
        'dvs_consignee' => get_option( 'dvs_dodeliver_consignee' ),
        'dvs_remarks' => get_option( 'dvs_dodeliver_remarks' ),
        'dvs_product' => get_option( 'dvs_dodeliver_product' ),
        'dvs_product_check' => get_option( 'dvs_dodeliver_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_dodeliver_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_dodeliver_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_dodeliver_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_dodeliver_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_dodeliver_cod_check' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'dodeliver_bulk_actions',101 );
function dodeliver_bulk_actions( $bulk_array ) {
    $dvs_dodeliver_enable = get_option( 'dvs_dodeliver_enable' );
    if ($dvs_dodeliver_enable == 1 ) {
        $bulk_array['mark_dodeliver_orders'] = 'Do Deliver Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_dodeliver_bulk_action_handler', 10, 4 );
function dvs_dodeliver_bulk_action_handler( $redirect, $doaction, $object_ids ) {
	if ( $doaction !== 'mark_dodeliver_orders' ) {
	    return $redirect;
	}
    $orders_data = [];
    $orders_items = [];
	foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_dodeliver_orders_data($order_id);

    }
    dvs_dodeliver_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'dodeliver_single_order_action', 10, 1 );
function dodeliver_single_order_action( $actions ) {
    $dvs_dodeliver_enable = get_option( 'dvs_dodeliver_enable' );
    if ($dvs_dodeliver_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['dodeliver_action'] = __( 'Book at Do Deliver' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_dodeliver_action', 'dodeliver_single_order_booking' );
function dodeliver_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_dodeliver_orders_data($order_id);
    dvs_dodeliver_body_data($orders_data);
    die();
}


add_action( 'init', 'dodeliver_submit_form' );
function dodeliver_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'dodeliver' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "DO DELIVER",
				'dvs_dodeliver_token' => get_option('dvs_dodeliver_token'),
                'dvs_dodeliver_pickup' => get_option('dvs_dodeliver_pickup'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  
            $current_order = $order;

            if ($response['status'] === true) {
                $order = new WC_Order($order_id);
                $dodeliver_tracking = $response['order']['tracking_id'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$dodeliver_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at Do Deliver with Tracking # ".$dodeliver_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'Do Deliver');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $dodeliver_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_courier_link = 'https://dodeliver.com.pk/tracking-detail/?track_no='.$dodeliver_tracking;
                update_post_meta( $order->get_id(), '_dvs_courier_link', $dvs_courier_link ); 

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $dodeliver_tracking, 'Do Deliver');

                $trackings[] = $dodeliver_tracking;
                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }    

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/dodeliver-label-logo.png'; ?>" height="50px">    
            <h3>Do Deliver Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }

            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_dodeliver = get_option( 'dvs_courier_dodeliver' ) + $count ;
        update_option('dvs_courier_dodeliver', $dvs_courier_dodeliver);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'POSTEX',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}

