<?php

if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_rider_plugin_settings' );
function dvs_rider_plugin_settings() {
	register_setting( 'dvs-rider-settings-group', 'dvs_rider_enable' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_login' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_api' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_pickup' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_city' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_delivery' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_payment' );        
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_type' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_handling' );        
	register_setting( 'dvs-rider-settings-group', 'dvs_rider_consignee' );       
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_remarks' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_product' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_product_check' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_pieces_check' );     
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_sku_check' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_notes_check' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_weight_check' );
    register_setting( 'dvs-rider-settings-group', 'dvs_rider_cod_check' );                                
}


//Courier settings input fields
function dvs_rider_api_page() { ?>
<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-rider-settings-group' );
	do_settings_sections( 'dvs-rider-settings-group' );
    $dvs_rider_pickup = get_option('dvs_rider_pickup');
    $dvs_rider_city = get_option('dvs_rider_city');
    $dvs_rider_delivery = get_option('dvs_rider_delivery');
    $dvs_rider_payment = get_option('dvs_rider_payment');        
	$dvs_rider_type = get_option('dvs_rider_type');			
	$dvs_rider_handling = get_option('dvs_rider_handling');
	$dvs_rider_consignee = get_option('dvs_rider_consignee');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/rider-label-logo.png'; ?>" height="50px">
    <h2>Rider Settings</h2>
    <table class="form-table">

        <tr>
        <th scope="row">Enable Rider API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_rider_enable" value="1" ' . checked( 1, get_option( 'dvs_rider_enable' ), false ) . ' />';?>
        </td>
        </tr> 

        <tr>
        <th scope="row">Login ID</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_rider_login" value="<?php echo esc_attr( get_option('dvs_rider_login') ); ?>" required/></td>
        </tr>

        <tr>
        <th scope="row">API Key</th>
        <td><input class="regular-text" placeholder="" type="password" name="dvs_rider_api" value="<?php echo esc_attr( get_option('dvs_rider_api') ); ?>" required/></td>
        </tr>

        <?php

        $get_dvs_rider_login = get_option('dvs_rider_login');
        $get_dvs_rider_api = get_option('dvs_rider_api');

        if($get_dvs_rider_api && $get_dvs_rider_login) {

            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'http://api.withrider.com/rider/v1/GetShipperLocations?loginId='.$get_dvs_rider_login.'&apikey='.$get_dvs_rider_api,
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 10,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
            ));

            $response = curl_exec($curl);
            curl_close($curl);
            $result = json_decode($response, true);
            
            if(!empty($result[0]['id'])) { ?>

                <tr>
                <th scope="row">Pickup Address</th>
                <td>
                    <select id="dvs_rider_pickup" name="dvs_rider_pickup" >
                    <?php
                    foreach ($result as $pickup) { ?>
                        <option value="<?php echo $pickup['address'] ?>" <?php selected($dvs_rider_pickup, $pickup['address']); ?>><?php echo $pickup['address'] ?></option>
                    <?php } ?>
                    </select>
                </td>
                </tr>

                <tr>
                <th scope="row">Shipper City</th>
                <td>
                <select id="dvs_rider_city" name="dvs_rider_city" required>
                    <?php 
                    $pickup_url = get_option( 'dvs_url' )."/woo/assets/rider-city.json";
                    $pickup_result = wp_remote_get($pickup_url);
                    $pickup_result = json_decode( wp_remote_retrieve_body( $pickup_result ), true );
                    foreach ($pickup_result as $pickup_city) { ?>
                        <option value="<?php echo $pickup_city['id'] ?>" <?php selected($dvs_rider_city, $pickup_city['id']); ?>><?php echo $pickup_city['description'] ?></option>
                    <?php } ?>
                </select>
                <td>        
                </tr>            
         
                <tr>
                <th scope="row">Shipment Type</th>
                <td>
                    <select id="dvs_rider_type" name="dvs_rider_type" required>
                    	<option value="1" <?php selected($dvs_rider_type,'1'); ?>>COD</option>
                        <option value="2" <?php selected($dvs_rider_type,'2'); ?>>Non COD</option>
                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Delivery Type</th>
                <td>
                    <select id="dvs_rider_delivery" name="dvs_rider_delivery" required>
                        <option value="1" <?php selected($dvs_rider_delivery,'1'); ?>>Same Day</option>
                        <option value="2" <?php selected($dvs_rider_delivery,'2'); ?>>1-3 Days</option>
                        <option value="5" <?php selected($dvs_rider_delivery,'5'); ?>>Detain</option>
                        <option value="6" <?php selected($dvs_rider_delivery,'6'); ?>>Overland</option>
                        <option value="7" <?php selected($dvs_rider_delivery,'7'); ?>>Overnight</option>
                        <option value="8" <?php selected($dvs_rider_delivery,'8'); ?>>Next Day</option>
                    </select>
                <td>        
                </tr>                

                <tr>
                <th scope="row">Payment Mode</th>
                <td>
                    <select id="dvs_rider_payment" name="dvs_rider_payment" required>
                    	<option value="2" <?php selected($dvs_rider_payment,'2'); ?>>Cash On Delivery</option>
                        <option value="1" <?php selected($dvs_rider_payment,'1'); ?>>Card On Delivery</option>
                        <option value="3" <?php selected($dvs_rider_payment,'3'); ?>> In-App Payment</option>
                    </select>
                <td>        
                </tr>                       

                <tr>
                <th scope="row">Shipment Handling</th>
                <td>
                    <select id="dvs_rider_handling" name="dvs_rider_handling" required>
                    	<option value="Yes" <?php selected($dvs_rider_handling,'Yes'); ?>>Fragile</option>
                    </select>
                <td>        
                </tr>        

                <tr>
                <th scope="row">Consginee Details</th>
                <td>
                    <select id="dvs_rider_consignee" name="dvs_rider_consignee" required>
                    <option value="Billing Details" <?php selected($dvs_rider_consignee,'Billing Details'); ?>>Billing Details</option>
                    <option value="Shipping Details" <?php selected($dvs_rider_consignee,'Shipping Details'); ?>>Shipping Details</option>
                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Default Remarks</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_rider_remarks" value="<?php echo esc_attr( get_option('dvs_rider_remarks') ); ?>" required/></td>
                </tr>

                <tr>
                <th scope="row">Default Product</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_rider_product" value="<?php echo esc_attr( get_option('dvs_rider_product') ); ?>" /></td>
                </tr>    

                <tr>
                <th scope="row">Print Item Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_rider_product_check" value="1" ' . checked( 1, get_option( 'dvs_rider_product_check' ), false ) . ' />';?>
                </td>
                </tr>

                <tr>
                <th scope="row">Print SKU Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_rider_sku_check" value="1" ' . checked( 1, get_option( 'dvs_rider_sku_check' ), false ) . ' />';?>
                </td>
                </tr>    

                <tr>
                <th scope="row">Print Order Notes in Remarks</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_rider_notes_check" value="1" ' . checked( 1, get_option( 'dvs_rider_notes_check' ), false ) . ' />';?>
                </td>
                </tr> 

                <tr>
                <th scope="row">Auto Calculate Weight</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_rider_weight_check" value="1" ' . checked( 1, get_option( 'dvs_rider_weight_check' ), false ) . ' />';?>
                </td>
                </tr>


                <tr>
                <th scope="row">Auto Calculate Pieces</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_rider_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_rider_pieces_check' ), false ) . ' />';?>
                </td>
                </tr>           

                <tr>
                <th scope="row">Calculate Non-COD as Zero</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_rider_cod_check" value="1" ' . checked( 1, get_option( 'dvs_rider_cod_check' ), false ) . ' />';?>
                </td>
                </tr>

            <?php
            }
            else {
                echo '<div class="notice notice-error is-dismissible"><p>Error: Invalid Login ID or API Key</p></div>';
            }
        }
        ?>                     

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<br>
<a href="https://devsol.pk/contact/" target="blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}

function dvs_rider_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',
        );
    }
    
    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );

    return $orders_data;
}



function dvs_rider_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'rider',
        'dvs_slug' => 'rider',
        'dvs_type' => get_option( 'dvs_rider_type' ),
        'dvs_handling' => get_option( 'dvs_rider_handling' ),
        'dvs_consignee' => get_option( 'dvs_rider_consignee' ),
        'dvs_remarks' => get_option( 'dvs_rider_remarks' ),
        'dvs_product' => get_option( 'dvs_rider_product' ),
        'dvs_product_check' => get_option( 'dvs_rider_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_rider_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_rider_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_rider_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_rider_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_rider_cod_check' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'rider_bulk_actions',101 );
function rider_bulk_actions( $bulk_array ) {
    $dvs_rider_enable = get_option( 'dvs_rider_enable' );
    if ($dvs_rider_enable == 1 ) {
        $bulk_array['mark_rider_orders'] = 'Rider Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_rider_bulk_action_handler', 10, 4 );
function dvs_rider_bulk_action_handler( $redirect, $doaction, $object_ids ) {
    if ( $doaction !== 'mark_rider_orders' ) {
        return $redirect;
    }
    $orders_data = [];
    $orders_items = [];
    foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_rider_orders_data($order_id);

    }
    dvs_rider_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'rider_single_order_action', 10, 1 );
function rider_single_order_action( $actions ) {
    $dvs_rider_enable = get_option( 'dvs_rider_enable' );
    if ($dvs_rider_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['rider_action'] = __( 'Book at Rider' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_rider_action', 'rider_single_order_booking' );
function rider_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_rider_orders_data($order_id);
    dvs_rider_body_data($orders_data);
    die();
}


add_action( 'init', 'rider_submit_form' );
function rider_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'rider' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "RIDER",
                'dvs_rider_login' => get_option('dvs_rider_login'),   
                'dvs_rider_api' => get_option('dvs_rider_api'),            
                'dvs_rider_pickup'  =>  get_option('dvs_rider_pickup'),
                'dvs_rider_city'  =>  get_option('dvs_rider_city'),
                'dvs_rider_delivery'  =>  get_option('dvs_rider_delivery'),
                'dvs_rider_payment'  =>  get_option('dvs_rider_payment'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  
            $current_order = $order;

            if($response['message'] == "Transaction Successful") {
                $order = new WC_Order($order_id);
                $rider_tracking = $response['CNUM'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$rider_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at rider with Tracking # ".$rider_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'Rider');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $rider_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_courier_link = 'https://track.withrider.com//#/track/'.$rider_tracking;
                update_post_meta( $order->get_id(), '_dvs_courier_link', $dvs_courier_link ); 

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $rider_tracking, 'Rider');

                $trackings[] = $rider_tracking;
                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }   

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/rider-label-logo.png'; ?>" height="50px">    
            <h3>Rider Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }

            if($trackings) {
                $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));
            }

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }

            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_rider = get_option( 'dvs_courier_rider' ) + $count ;
        update_option('dvs_courier_rider', $dvs_courier_rider);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'RIDER',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}

