<?php

if ( ! defined( 'ABSPATH' ) ) exit;


//register plugin field settings
add_action( 'admin_init', 'dvs_rocket_plugin_settings' );
function dvs_rocket_plugin_settings() {
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_enable' );	
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_shipper_api' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_shipper_delivery' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_shipper_type' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_shipper_payment' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_type' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_handling' );        
	register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_consignee' );       
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_remarks' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_product' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_product_check' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_pieces_check' );     
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_sku_check' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_notes_check' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_weight_check' );
    register_setting( 'dvs-rocket-settings-group', 'dvs_rocket_cod_check' );
}

//Courier settings input fields
function dvs_rocket_api_page() { ?>
    
<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-rocket-settings-group' );
	do_settings_sections( 'dvs-rocket-settings-group' ); 
	$dvs_rocket_type = get_option('dvs_rocket_type');
	$dvs_rocket_handling = get_option('dvs_rocket_handling');
	$dvs_rocket_consignee = get_option('dvs_rocket_consignee');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/rocket-label-logo.png'; ?>" height="50px">
    <h2>Rocket Courier Settings</h2>
    <table class="form-table">

        <tr>
        <th scope="row">Enable rocket API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_rocket_enable" value="1" ' . checked( 1, get_option( 'dvs_rocket_enable' ), false ) . ' />';?>
        </td>
        </tr>               

        <tr>
        <th scope="row">API Key</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_rocket_shipper_api" value="<?php echo esc_attr( get_option('dvs_rocket_shipper_api') ); ?>" /></td>
        </tr>

        <tr>
        <th scope="row">Delivery Type</th>
        <td>
            <select id="dvs_rocket_shipper_delivery" name="dvs_rocket_shipper_delivery" >
            <option value='package'>Package</option>
            <option value='envelope'>Envelope</option>            
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Service Type</th>
        <td>
            <select id="dvs_rocket_shipper_type" name="dvs_rocket_shipper_type" >
            <option value='regular'>Regular</option>
            <option value='express'>Express</option>            
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Payment Type</th>
        <td>
            <select id="dvs_rocket_shipper_payment" name="dvs_rocket_shipper_payment" >
            <option value='cash'>Cash</option>
            <option value='bank account'>Bank Account</option>            
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Shipment Type</th>
        <td>
            <select id="dvs_rocket_type" name="dvs_rocket_type" required>
                <option value="Overnight" <?php selected($dvs_rocket_type,'Overnight'); ?>>Overnight</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Shipment Handling</th>
        <td>
            <select id="dvs_rocket_handling" name="dvs_rocket_handling" required>
            	<option value="Yes" <?php selected($dvs_rocket_handling,'Yes'); ?>>Fragile</option>
            	<option value="No" <?php selected($dvs_rocket_handling,'No'); ?>>Non Fragile</option>
            </select>
        <td>        
        </tr>        

        <tr>
        <th scope="row">Consginee Details</th>
        <td>
            <select id="dvs_rocket_consignee" name="dvs_rocket_consignee" required>
            <option value="Billing Details" <?php selected($dvs_rocket_consignee,'Billing Details'); ?>>Billing Details</option>
            <option value="Shipping Details" <?php selected($dvs_rocket_consignee,'Shipping Details'); ?>>Shipping Details</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Default Remarks</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_rocket_remarks" value="<?php echo esc_attr( get_option('dvs_rocket_remarks') ); ?>" required/></td>
        </tr>

        <tr>
        <th scope="row">Default Product</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_rocket_product" value="<?php echo esc_attr( get_option('dvs_rocket_product') ); ?>" /></td>
        </tr>    

        <tr>
        <th scope="row">Print Item Name in Label</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_rocket_product_check" value="1" ' . checked( 1, get_option( 'dvs_rocket_product_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Print SKU Name in Label</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_rocket_sku_check" value="1" ' . checked( 1, get_option( 'dvs_rocket_sku_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Print Order Notes in Remarks</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_rocket_notes_check" value="1" ' . checked( 1, get_option( 'dvs_rocket_notes_check' ), false ) . ' />';?>
        </td>
        </tr>        

        <tr>
        <th scope="row">Auto Calculate Weight</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_rocket_weight_check" value="1" ' . checked( 1, get_option( 'dvs_rocket_weight_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Auto Calculate Pieces</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_rocket_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_rocket_pieces_check' ), false ) . ' />';?>
        </td>
        </tr>           

        <tr>
        <th scope="row">Calculate Non-COD as Zero</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_rocket_cod_check" value="1" ' . checked( 1, get_option( 'dvs_rocket_cod_check' ), false ) . ' />';?>
        </td>
        </tr>                              

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<a href="https://www.youtube.com/watch?v=9YzKw-hJi2M" target="_blank" class="woocommerce-Button button">Video: How to configure rocket Settings</a>
<br>
<br>
<a href="https://devsol.pk/contact/" target="_blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="_blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}




function dvs_rocket_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',

        );
    }

    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );
    
    return $orders_data;
}



function dvs_rocket_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'ROCKET',
        'dvs_slug' => 'rocket',
        'dvs_type' => get_option( 'dvs_rocket_type' ),
        'dvs_handling' => get_option( 'dvs_rocket_handling' ),
        'dvs_consignee' => get_option( 'dvs_rocket_consignee' ),
        'dvs_remarks' => get_option( 'dvs_rocket_remarks' ),
        'dvs_product' => get_option( 'dvs_rocket_product' ),
        'dvs_product_check' => get_option( 'dvs_rocket_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_rocket_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_rocket_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_rocket_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_rocket_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_rocket_cod_check' ),
        'dvs_rocket_insurance' => get_option( 'dvs_rocket_insurance' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'rocket_bulk_actions',101 );
function rocket_bulk_actions( $bulk_array ) {
    $dvs_rocket_enable = get_option( 'dvs_rocket_enable' );
    if ($dvs_rocket_enable == 1 ) {
        $bulk_array['mark_rocket_orders'] = 'Rocket Courier Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_rocket_bulk_action_handler', 10, 4 );
function dvs_rocket_bulk_action_handler( $redirect, $doaction, $object_ids ) {
	if ( $doaction !== 'mark_rocket_orders' ) {
	    return $redirect;
	}
    $orders_data = [];
    $orders_items = [];
	foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_rocket_orders_data($order_id);

    }
    dvs_rocket_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'rocket_single_order_action', 10, 1 );
function rocket_single_order_action( $actions ) {
    $dvs_rocket_enable = get_option( 'dvs_rocket_enable' );
    if ($dvs_rocket_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['rocket_action'] = __( 'Book at Rocket Courier' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_rocket_action', 'rocket_single_order_booking' );
function rocket_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_rocket_orders_data($order_id);
    dvs_rocket_body_data($orders_data);
    die();
}


add_action( 'init', 'rocket_submit_form' );
function rocket_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'rocket' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        $trackings = [];

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "ROCKET",
                'dvs_rocket_shipper_api' => get_option('dvs_rocket_shipper_api'),             
                'dvs_rocket_shipper_delivery'  =>  get_option('dvs_rocket_shipper_delivery'),
                'dvs_rocket_shipper_type'  =>  get_option('dvs_rocket_shipper_type'),
                'dvs_rocket_shipper_payment' => get_option('dvs_rocket_shipper_payment'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  

            $current_order = $order;

            if ($response['message'] == 'AWB was created' && $response['status'] == 'done' ) {
                $order = new WC_Order($order_id);
                $rocket_tracking = $response['data']['no'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$rocket_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at Rocket Courier with Tracking # ".$rocket_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'Rocket Courier');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $rocket_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_courier_link = 'https://rocketcourier.pk/tracking/';
                update_post_meta( $order->get_id(), '_dvs_courier_link', $dvs_courier_link ); 

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $rocket_tracking, 'Rocket Courier');

                $trackings[] = $rocket_tracking;

                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }           

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/rocket-label-logo.png'; ?>" height="50px">    
            <h3>rocket Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }
            
            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_rocket = get_option( 'dvs_courier_rocket' ) + $count ;
        update_option('dvs_courier_rocket', $dvs_courier_rocket);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'ROCKET',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}
