<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_filter( 'woocommerce_register_shop_order_post_statuses', 'dvs_register_shipped_order_status' );
function dvs_register_shipped_order_status( $order_statuses ) {

   $order_statuses['wc-booked'] = array(                                 
   'label'                     => _x( 'Booked', 'Order status booked', 'woocommerce' ),
   'public'                    => true,                                 
   'exclude_from_search'       => false,                                 
   'show_in_admin_all_list'    => true,                                 
   'show_in_admin_status_list' => true,                                 
   'label_count'               => _n_noop( 'Booked <span class="count">(%s)</span>', 'Booked <span class="count">(%s)</span>', 'woocommerce' ),                              
   );

   $order_statuses['wc-shipped'] = array(                                 
   'label'                     => _x( 'Shipped', 'Order status shipped', 'woocommerce' ),
   'public'                    => true,                                 
   'exclude_from_search'       => false,                                 
   'show_in_admin_all_list'    => true,                                 
   'show_in_admin_status_list' => true,                                 
   'label_count'               => _n_noop( 'Shipped <span class="count">(%s)</span>', 'Shipped <span class="count">(%s)</span>', 'woocommerce' ),                              
   );

   $order_statuses['wc-delivered'] = array(                                 
   'label'                     => _x( 'Delivered', 'Order status delivered', 'woocommerce' ),
   'public'                    => true,                                 
   'exclude_from_search'       => false,                                 
   'show_in_admin_all_list'    => true,                                 
   'show_in_admin_status_list' => true,                                 
   'label_count'               => _n_noop( 'Delivered <span class="count">(%s)</span>', 'Delivered <span class="count">(%s)</span>', 'woocommerce' ),                              
   );

   $order_statuses['wc-refused'] = array(                                 
   'label'                     => _x( 'Refused', 'Order status refused', 'woocommerce' ),
   'public'                    => true,                                 
   'exclude_from_search'       => false,                                 
   'show_in_admin_all_list'    => true,                                 
   'show_in_admin_status_list' => true,                                 
   'label_count'               => _n_noop( 'Refused <span class="count">(%s)</span>', 'Refused <span class="count">(%s)</span>', 'woocommerce' ),                              
   );

   $order_statuses['wc-returned'] = array(                                 
   'label'                     => _x( 'Returned', 'Order status refused', 'woocommerce' ),
   'public'                    => true,                                 
   'exclude_from_search'       => false,                                 
   'show_in_admin_all_list'    => true,                                 
   'show_in_admin_status_list' => true,                                 
   'label_count'               => _n_noop( 'Returned <span class="count">(%s)</span>', 'Returned <span class="count">(%s)</span>', 'woocommerce' ),                              
   );      

   return $order_statuses;
}

add_filter( 'wc_order_statuses', 'dvs_show_shipped_order_status' );
function dvs_show_shipped_order_status( $order_statuses ) {
    $order_statuses['wc-booked'] = _x( 'Booked', 'Order status', 'woocommerce' );
    $order_statuses['wc-shipped'] = _x( 'Shipped', 'Order status', 'woocommerce' );
    $order_statuses['wc-delivered'] = _x( 'Delivered', 'Order status', 'woocommerce' );
    $order_statuses['wc-refused'] = _x( 'Refused', 'Order status', 'woocommerce' );
    $order_statuses['wc-returned'] = _x( 'Returned', 'Order status', 'woocommerce' );
    return $order_statuses;
}

add_filter( 'bulk_actions-edit-shop_order', 'dvs_get_shipped_order_status_bulk' );
function dvs_get_shipped_order_status_bulk( $bulk_actions ) {
    $bulk_actions['mark_booked'] = 'Change status to booked';
    $bulk_actions['mark_shipped'] = 'Change status to shipped';
    $bulk_actions['mark_delivered'] = 'Change status to delivered';
    $bulk_actions['mark_refused'] = 'Change status to refused';
    $bulk_actions['mark_returned'] = 'Change status to returned';
    return $bulk_actions;
}

add_action('admin_head', 'dvs_shipped_status_styling');
function dvs_shipped_status_styling() {
echo '<style>
    .status-shipped {
        background: #ffffff;
        color: #4c56b8;
        border: 1px solid #4c56b8;        
    }
    .status-booked {
        background: #ffffff;
        color: #94660c;
        border: 1px solid #94660c;        
    }
    .status-delivered {
        background: #23a061;
        color: #ffffff;
        border: 1px solid #23a061;        
    }    
    .status-refused {
        background: #ffffff;        
        color: #eb353d;
        border: 1px solid #eb353d;     
    }
    .status-returned {
        background: #eb353d;        
        color: #ffffff;
        border: 1px solid #eb353d;     
    }                
</style>';
}

add_action( 'woocommerce_order_status_shipped', 'dvs_shipped_status_notification', 20, 2 );
function dvs_shipped_status_notification( $order_id, $order ) {  
	$dvsorderno = $order->get_order_number();
    $heading = 'Order Shipped';
    $subject = 'Your Order #' .$dvsorderno . ' Has Been Shipped';
    $mailer = WC()->mailer()->get_emails();
    $mailer['WC_Email_Customer_Invoice']->heading = $heading;
    $mailer['WC_Email_Customer_Invoice']->settings['heading'] = $heading;
    $mailer['WC_Email_Customer_Invoice']->subject = $subject;
    $mailer['WC_Email_Customer_Invoice']->settings['subject'] = $subject;
    $mailer['WC_Email_Customer_Invoice']->trigger( $order_id );     
}

add_action( 'woocommerce_email_before_order_table', 'dvs_shipped_specific_email', 20, 4 );
function dvs_shipped_specific_email( $order, $sent_to_admin, $plain_text, $email ) {
   if ( $email->id == 'customer_invoice' ) {          
	   	if ($order->get_status() == "shipped") {
    		$orderiddd = $order->get_id();	
    		$dvsorderno = $order->get_order_number();
    		$urltrack = site_url()."/track";	
    		$dvs_courier_list_email = get_post_meta( $orderiddd, '_dvs_courier_list', true );
    		$dvs_courier_tracking_email = get_post_meta( $orderiddd, '_dvs_courier_tracking', true );

    		echo 'Great News! Your order # ' . $dvsorderno . ' has been shipped and deliver to you shortly.';
    		echo '<br>';
    		echo '<br>';
            if(!empty($dvs_courier_list_email)) {
                echo '<strong>Courier Name: </strong> ' . $dvs_courier_list_email .'';
                echo '<br>';
                echo '<strong>Tracking CN: </strong>' . $dvs_courier_tracking_email .'';
                echo '<br>';
                echo '<br>'; 
                echo 'You can track your order from this link: ' . $urltrack .'';
                echo '<br>';
                echo '<br>';     
            }	
	   }
   }
}


add_action( 'woocommerce_order_status_delivered', 'dvs_delivered_status_notification', 20, 2 );
function dvs_delivered_status_notification( $order_id, $order ) {  
    $dvsorderno = $order->get_order_number();
    $heading = 'Order Delivered';
    $subject = 'Your Order #' .$dvsorderno . ' Has Been Delivered';
    $mailer = WC()->mailer()->get_emails();
    $mailer['WC_Email_Customer_Invoice']->heading = $heading;
    $mailer['WC_Email_Customer_Invoice']->settings['heading'] = $heading;
    $mailer['WC_Email_Customer_Invoice']->subject = $subject;
    $mailer['WC_Email_Customer_Invoice']->settings['subject'] = $subject;
    $mailer['WC_Email_Customer_Invoice']->trigger( $order_id );     
}

add_action( 'woocommerce_email_before_order_table', 'dvs_delivered_specific_email', 20, 4 );
function dvs_delivered_specific_email( $order, $sent_to_admin, $plain_text, $email ) {
   if ( $email->id == 'customer_invoice' ) {          
        if ($order->get_status() == "delivered") {
            $orderiddd = $order->get_id();  
            $dvsorderno = $order->get_order_number();
            echo 'Great News! Your order # ' . $dvsorderno . ' has been delivered.';
            echo '<br>';
            echo '<br>';  
       }
   }
}