<?php

    if ( ! defined( 'ABSPATH' ) ) exit;

function dvs_track_shipment($order_id, $courier, $tracking, $print=true) {
    global $wpdb;
    if(!empty($order_id) && !empty($courier) && !empty($tracking)) {
        $order = wc_get_order( $order_id );
        if(json_encode($order) != 'false') {
            $order_no = $order->get_order_number();
            $order_status = $order->get_status();
            $dvs_label_shipper_shipped = get_option('dvs_label_shipper_shipped');
            $dvs_label_shipper_delivered = get_option('dvs_label_shipper_delivered');
            $dvs_label_shipper_refused = get_option('dvs_label_shipper_refused');
            $dvs_label_shipper_returned = get_option('dvs_label_shipper_returned');

        // TCS TRACKING    
            if ($courier == 'TCS') {
                $dvs_tcs_enable = get_option( 'dvs_tcs_enable' );
                if ($dvs_tcs_enable == 1 ) {

                    $dvs_tcs_auth = get_option( 'dvs_tcs_auth' );

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://connect.tcscourier.com/tracking/api/Tracking/GetDynamicTrackDetail?consignee='.$tracking.'&timezone=true',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'Authorization: Bearer '.$dvs_tcs_auth
                      ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    if($data['message'] == "SUCCESS") {

                        if(isset($data['deliveryinfo'])) {
                            $current_status = trim($data['deliveryinfo'][0]['status']);
                        }
                        else if(isset($data['checkpoints'])) {
                            $current_status = trim($data['checkpoints'][0]['status']);
                        }                        
                        else {
                            $current_status = 'Shipment - Booked';
                        }

                        $output =   '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://www.tcsexpress.com/track/' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        
                        if(isset($data['checkpoints'])) {
                            foreach ($data['checkpoints'] as $status) {
                                $output.=   '<tr>';
                                $output.=   '<td>' .$status['datetime']. '</td>';                       
                                $output.=   '<td>' .$status['status']. '</td>';
                                $output.=   '<td>' .$status['recievedby']. '</td>';
                                $output.=   '</tr>';                                 
                            }
                        }
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found / Not Picked up<hr><span style="font-size:12px">Response:' . $response . '</span>';
                    }
                }
            }

        // LEOPARDS COURIER TRACKING
            else if ($courier == 'Leopards Courier') {
                $dvs_lcs_enable = get_option( 'dvs_lcs_enable' );
                if ($dvs_lcs_enable == 1 ) {
                    $dvs_lcs_portal = get_option('dvs_lcs_portal');
                    $dvs_lcs_api = get_option('dvs_lcs_api');
                    $dvs_lcs_password = get_option('dvs_lcs_password');

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://merchantapi.leopardscourier.com/api/trackBookedPacket/format/json/',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 10,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => array('api_key' => $dvs_lcs_api,'api_password' => $dvs_lcs_password,'track_numbers' => $tracking),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);
                    $data = json_decode($response, true);

                    if ($data['status'] == 1 ) {
                        foreach ($data['packet_list'] as $a) {

                            if (isset($a['Tracking Detail']) && is_array($a['Tracking Detail']) && count($a['Tracking Detail']) > 0) {
                                $current_status = trim(end($a['Tracking Detail'])['Status']) ?? '';
                            } elseif (isset($a['booked_packet_status'])) {
                                $current_status = $a['booked_packet_status'];
                            }

                            $output =   '';
                            $output.=   '<div class="order-details">';                       
                            $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                            $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                            $output.=   '</div>';
                            $output.=   '<div class="tracking-details">';                       
                            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                            $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://merchantapi.leopardscourier.com/track?no='.$tracking.'" target="blank">' .$tracking. '</a></div>';
                            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                            $output.=   '</div>'; 
                            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                            $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                            foreach ($a['Tracking Detail'] as $b) {
                                $output.=   '<tr>';                
                                $output.=   '<td>' .$b['Activity_datetime']. '</td>';
                                $output.=   '<td>' .$b['Status']. '</td>';                
                                $output.=   '<td>' .$b['Reason']. ' ' .$b['Reciever_Name']. '</td>';
                                $output.=   '</tr>';                                 
                            }
                            $output.=   '</table>';

                        }
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }
                }
            }

        // TRAX TRACKING
            else if ($courier == 'Trax') {
                $dvs_trax_enable = get_option( 'dvs_trax_enable' );
                if ($dvs_trax_enable == 1 ) {
                    $dvs_trax_api = get_option( 'dvs_trax_api' );
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://sonic.pk/api/shipment/track?tracking_number='.$tracking.'&type=0',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                      CURLOPT_HTTPHEADER => array(
                        'Authorization: '.$dvs_trax_api,
                        'Accept: application/json'
                      ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    if ($data['status'] == 0 ) {
                        $current_status = trim($data['details']['tracking_history'][0]['status']);
                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://www.sonic.pk/tracking?track=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        foreach ($data['details']['tracking_history'] as $a) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$a['date_time']. '</td>';                       
                            $output.=   '<td>' .$a['status']. '</td>';
                            $output.=   '<td>' .$a['status_reason']. '</td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }
                }
            }

        // MNP TRACKING
            else if ($courier == 'MNP') {
                $dvs_mnp_enable = get_option( 'dvs_mnp_enable' );
                if ($dvs_mnp_enable == 1 ) {                
                    $dvs_mnp_username = urlencode(get_option( 'dvs_mnp_username' ));
                    $dvs_mnp_password = urlencode(get_option( 'dvs_mnp_password' ));
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'http://mnpcourier.com/mycodapi/api/Tracking/Consignment_Tracking?username='.$dvs_mnp_username.'&password='.$dvs_mnp_password.'&consignment='.$tracking,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 10,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);
                    $data = $data[0];

                    if ($data['isSuccess'] == 'true') {
                        $current_status = trim($data['tracking_Details'][0]['CNStatus']);
                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://mulphilog.com.pk/track-shipment.php?track=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        foreach ($data['tracking_Details'][0]['Details'] as $a) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$a['DateTime']. '</td>';                       
                            $output.=   '<td>' .$a['Status']. '</td>';
                            $output.=   '<td>' .$a['Location']. ' ' .$a['Detail']. '</td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }
                }
            }

        // CALL COURIER TRACKING
            else if ($courier == 'Call Courier') {
                $dvs_ccs_enable = get_option( 'dvs_ccs_enable' );
                if ($dvs_ccs_enable == 1 ) {                
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'http://cod.callcourier.com.pk/api/CallCourier/GetTackingHistory?cn='.$tracking,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 10,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    $current_status = trim(end($data)['ProcessDescForPortal']);
                    $output = '';        
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://callcourier.com.pk/tracking/?tc=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    foreach ($data as $a) {
                        $output.=   '<tr>';
                        $output.=   '<td>' .$a['TransactionDate']. '</td>';                       
                        $output.=   '<td>' .$a['ProcessDescForPortal']. '</td>';
                        $output.=   '<td>' .$a['OperationDesc']. ' ' .$a['ReceiverName'].'</td>';
                        $output.=   '</tr>';                            
                    }             
                    $output.=   '</table>';
                }
            }

        // BLUEEX TRACKING
            else if ($courier == 'BlueEx') {
                $dvs_blx_enable = get_option( 'dvs_blx_enable' );
                if ($dvs_blx_enable == 1 ) {

                    $dvs_blx_api = get_option( 'dvs_blx_api' );
                    $dvs_blx_account = get_option( 'dvs_blx_account' );
                    $blx_token = base64_encode($dvs_blx_account . ':' . $dvs_blx_api);

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://bigazure.com/api/json_v3/tracking/get_tracking.php',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS =>'{"consignment_no": "'.$tracking.'"}',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'Authorization: Basic ='.$blx_token
                      ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response,true);

                    if($data['status'] == 1) {
                        $output = '';        
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://www.blue-ex.com/tracking?trackno=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>';

                        $current_status = trim($data['response'][0]['status_message']);
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Date</th><th>Time</th><th>Status</th></tr>';
                        foreach ($data['response'] as $key) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$key['status_date']. '</td>';                       
                            $output.=   '<td>' .$key['status_time']. '</td>';
                            $output.=   '<td>' .$key['status_message']. '</td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;               
                    }
                }
            }

        // SWYFT LOGISTICS TRACKING
            else if ($courier == 'Swyft Logistics') {
                $dvs_swyft_enable = get_option( 'dvs_swyft_enable' );
                if ($dvs_swyft_enable == 1 ) {                
                    $dvs_swyft_vendor = get_option( 'dvs_swyft_vendor' );
                    $dvs_swyft_api = get_option( 'dvs_swyft_api' );
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://vendor-api.swyft-logistics.com/api/'.$dvs_swyft_vendor.'/get-parcel-histroy/'.$tracking,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 10,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        CURLOPT_HTTPHEADER => array(
                        'Authorization: '.$dvs_swyft_api,
                        'Accept: application/json'
                        ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response,true);

                    $current_status = trim(end($data)['status']);

                    $output = '';        
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="http://parceltracking.swyft-logistics.com/?' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    foreach ($data as $a) {
                        $output.=   '<tr>';
                        $output.=   '<td>' .substr($a['date'],0,-14). '</td>';                       
                        $output.=   '<td>' .$a['status']. '</td>';
                        $output.=   '<td></td>';
                        $output.=   '</tr>';                            
                    }             
                    $output.=   '</table>';
                }
            }

        // DAEWOO COURIER TRACKING
            else if ($courier == 'Daewoo Courier') {
                $dvs_daewoo_enable = get_option( 'dvs_daewoo_enable' );
                if ($dvs_daewoo_enable == 1 ) {                
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://codapi.daewoo.net.pk/api/booking/quickTrack?trackingNo='.$tracking,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 10,
                        CURLOPT_SSL_VERIFYPEER => false,
                        CURLOPT_SSL_VERIFYHOST => false,                             
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response,true);

                    if(isset(end($data['Result']['TrackingDetails'])['Status_Reason'])) {
                        $current_status = end($data['Result']['TrackingDetails'])['Status_Reason'];
                    }
                    else {
                        $current_status = "Booked";
                    }

                    $output = '';        
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://fastex.pk?track=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    if(isset($data['Result']['TrackingDetails'])) {
                        foreach ($data['Result']['TrackingDetails'] as $a) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$a['PortalDate']. '</td>';                       
                            $output.=   '<td>' .$a['Status_Reason'].'</td>';
                            $output.=   '<td>' .$a['Status']. ' - ' .$a['remarks'].'</td>';
                            $output.=   '</tr>';                            
                        }
                    }
            
                    $output.=   '</table>';
                }
            }  



            // POSTEX TRACKING
            else if ($courier == 'PostEx') {
                $dvs_postex_enable = get_option( 'dvs_postex_enable' );
                if ($dvs_postex_enable == 1 ) {                
                    $dvs_postex_token = get_option('dvs_postex_token');
                    $url = "https://api.postex.pk/services/integration/api/order/v1/track-order/".$tracking;
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => $url,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 10,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                        CURLOPT_HTTPHEADER => array(
                        'token: '.$dvs_postex_token
                        ),
                    ));
                    $result = curl_exec($curl);
                    curl_close($curl);
					
                    $data = json_decode($result, true);

                    if($data['statusCode'] == 200) {

                        $current_status = trim(end($data['dist']['transactionStatusHistory'])['transactionStatusMessage']);
                        
                        if(empty($current_status)) {
                            $current_status = 'Booked';
                        }

                        // $current_status = trim($data['dist']['transactionStatus']);

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://merchant.postex.pk/?cn=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        foreach ($data['dist']['transactionStatusHistory'] as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .substr($status['updatedAt'],0,-18). '</td>';                       
                            $output.=   '<td>' .$status['transactionStatusMessage']. '</td>';
                            $output.=   '<td>' .$status['transactionStatusMessageCode']. '</td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }
                }
            }




          // SHIP NOC
            else if ($courier == 'Ship NOC') {
                $dvs_noc_enable = get_option( 'dvs_noc_enable' );
                if ($dvs_noc_enable == 1 ) { 


                    $shipper_api = get_option('dvs_noc_username');
                    $shipper_code = get_option('dvs_noc_password');

                    $shipper_username = urlencode($shipper_api);
                    $shipper_password = urlencode($shipper_code);
                    
                    $noc_signature = $shipper_api . $shipper_code . "noc@#";
                    $noc_signature = urlencode($noc_signature);
                            
                    $noc_track_url = 'http://api.shipnoc.com/api/GetParcelTracking?UserName=' . $shipper_username . '&Password=' . $shipper_password . '&Signature=' . $noc_signature . '&ParcelNo=' . $tracking;

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => $noc_track_url,
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,  
                      CURLOPT_SSL_VERIFYPEER => false,
                      CURLOPT_SSL_VERIFYHOST => false,                    
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                      CURLOPT_HTTPHEADER => array(
                        'Accept: application/json'
                      ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    if ($data['Response'] == "success") {

                        $current_status = $data['detail'][0]['PacelStatus'];
                        
                        if(empty($current_status)) {
                            $current_status = 'Booked';
                        }

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://shipnoc.com/noc/BulkTracfk.aspx" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

                        foreach ($data['detail'] as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$status['DateTime']. '</td>';                       
                            $output.=   '<td>' .$status['PacelStatus']. '</td>';
                            $output.=    '<td>' .$status['Remarks']. '</td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }
                }
            }



            // INSTA TRACKING
            else if ($courier == 'Insta World') {
                $dvs_insta_enable = get_option( 'dvs_insta_enable' );
                if ($dvs_insta_enable == 1 ) {                
                    $dvs_insta_token = get_option('dvs_insta_token');

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://one-be.instaworld.pk/logistics/v1/trackShipment',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS =>'{
                        "api_key": "'.$dvs_insta_token.'",
                        "tracking_number": "'.$tracking.'"
                    }',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                      ),
                    ));
                    $result = curl_exec($curl);
                    curl_close($curl);
                    
                    $data = json_decode($result, true);

                    if(isset($data[0]['status'])) {

                        $current_status = end($data)['status'];
                        
                        if(empty($current_status)) {
                            $current_status = 'Booked';
                        }

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://one.instaworld.pk/track" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

                        foreach ($data as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$status['date_time']. '</td>';                       
                            $output.=   '<td>' .$status['status']. '</td>';
                            $output.=   '<td></td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $result;
                    }
                }
            }

            // DO DELIVER
            else if ($courier == 'Do Deliver') {
                $dvs_dodeliver_enable = get_option( 'dvs_dodeliver_enable' );
                if ($dvs_dodeliver_enable == 1 ) {                
                    $dvs_dodeliver_token = get_option('dvs_dodeliver_token');

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://portal.dodeliver.com.pk/api/orders/'.$tracking.'?api_key='.$dvs_dodeliver_token,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 10,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'GET',
                    CURLOPT_HTTPHEADER => array(
                    'Accept: application/json'
                    ),
                    ));
                    $result = curl_exec($curl);
                    curl_close($curl);
                    
                    $data = json_decode($result, true);

                    if ($data['status'] === true) {

                        $current_status = $data['order_detail']['status_name'];
                        
                        if(empty($current_status)) {
                            $current_status = 'Booked';
                        }

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://dodeliver.com.pk/tracking-detail/?track_no='.$tracking.'" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

                        foreach ($data['timeline'][0]['status'] as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$status['time']. '</td>';                       
                            $output.=   '<td>' .$status['log']. '</td>';
                            $output.=   '<td></td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $result;
                    }
                }
            }

            // FALCOMAIL
            else if ($courier == 'Falcomail') {
                $dvs_falcomail_enable = get_option( 'dvs_falcomail_enable' );
                if ($dvs_falcomail_enable == 1 ) {                
                    $dvs_falcomail_token = get_option('dvs_falcomail_token');


                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://app.falcomail.com.pk/api/TrackOrder',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 5,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS => '{
                        "tracking_no": "'.$tracking.'"
                    }',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                      ),
                    ));
                    $result = curl_exec($curl);
                    curl_close($curl);
                    
                    $data = json_decode($result, true);

                    if($data['result']['status'] != "error") {

                        $current_status = $data['result'][0]['status'];
                        
                        if(empty($current_status)) {
                            $current_status = 'Booked';
                        }

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://www.falcomail.com.pk/" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

                        foreach ($data['result'] as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$status['created']. '</td>';                       
                            $output.=   '<td>' .$status['status']. '</td>';
                            $output.=   '<td></td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $result;
                    }
                }
            }



        // COURIERX TRACKING    
            else if ($courier == 'Courierx') {
                $dvs_ccx_enable = get_option( 'dvs_ccx_enable' );
                if ($dvs_ccx_enable == 1 ) {                
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://cod.courierx.pk/api/PortalAPI/GetCNTracking?CN='.$tracking,
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response,true);

                    $current_status = trim($data['Status']);

                    $output = '';        
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://www.courierx.pk/tracking/?track_number=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Status</th><th>Time</th><th>Comments</th></tr>';
                    $line = 0;
                    foreach ($data['Details'] as $a) {
                        $output.=   '<tr>';
                        $output.=   '<td>' .$data['Details'][$line]. '</td>';
                        $line++;
                        $output.=   '<td>' .$data['Details'][$line]. '</td>';
                        $output.=   '<td> - </td>';
                        $output.=   '</tr>';
                        $line++;
                    }             
                    $output.=   '</table>';
                }
            }

        // MOVEX TRACKING    
            else if ($courier == 'Movex') {
                $dvs_movex_enable = get_option( 'dvs_movex_enable' );
                if ($dvs_movex_enable == 1 ) {                
                    $dvs_movex_api = get_option('dvs_movex_api');
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://tracking.movexpk.com/api/track/consignments?consignment_numbers='.$tracking,
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                      CURLOPT_HTTPHEADER => array(
                        'Authorization: '.$dvs_movex_api 
                    ),
                    ));
                    $result = curl_exec($curl);
                    curl_close($curl);
                    
                    $data = json_decode($result, true);

                    $current_status = trim($data['response']['success'][0]['tracking_details']['order_status']);

                    $output = '';
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://tracking.movexpk.com/tracking?tracking_number=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    foreach ($data['response']['success'][0]['tracking_details']['tracking_info'] as $status) {
                        $output.=   '<tr>';
                        $output.=   '<td>' .$status['created_datetime']. '</td>';                       
                        $output.=   '<td>' .$status['order_status']. '</td>';
                        $output.=   '<td>' .$status['message']. '</td>';
                        $output.=   '</tr>';                            
                    }             
                    $output.=   '</table>';
                }
            }

        // RIDER TRACKING
            else if ($courier == 'Rider') {
                $dvs_rider_enable = get_option( 'dvs_rider_enable' );
                if ($dvs_rider_enable == 1 ) {                
                    $dvs_rider_login = get_option( 'dvs_rider_login' );
                    $dvs_rider_api = get_option( 'dvs_rider_api' );
                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                        CURLOPT_URL => 'http://api.withrider.com/rider/v1/GetTackingHistory?cn='.$tracking.'&loginId='.$dvs_rider_login.'&apikey='.$dvs_rider_api,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 10,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'GET',
                    ));
                    $result = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($result, true);
                    $data = array_reverse($data);

                    $current_status = trim($data[0]['order_status']);

                    $output = '';
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://track.withrider.com?track=' .$tracking. '" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    foreach ($data as $status) {
                        $output.=   '<tr>';
                        $output.=   '<td>' .$status['updated_at']. '</td>';                       
                        $output.=   '<td>' .$status['order_status']. '</td>';
                        $output.=   '<td>' .$status['reason']. '</td>';
                        $output.=   '</tr>';                            
                    }             
                    $output.=   '</table>';
                }
            }


       // AHL COURIER TRACKING
            else if ($courier == 'AHL Courier') {
                $dvs_ahl_enable = get_option( 'dvs_ahl_enable' );
                if ($dvs_ahl_enable == 1 ) {

                    $get_dvs_ahl_email = get_option('dvs_ahl_email');
                    $get_dvs_ahl_password = get_option('dvs_ahl_password');

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://admin.ahlogistic.pk/api/shopify-vendor-access-token',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS => array('email' => $get_dvs_ahl_email,'password' => $get_dvs_ahl_password),
                    ));
                    $ahl_response = curl_exec($curl);
                    curl_close($curl);
                    $ahl_result = json_decode($ahl_response, true);

                    $access_token = $ahl_result['access_token'];

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://admin.ahlogistic.pk/api/shopify-order-track',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS => array('order_reference_no' => '#'.$tracking),
                      CURLOPT_HTTPHEADER => array(
                        'Authorization: Bearer '.$access_token
                      ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    $current_status = trim($data['order_track']['order_status']['name']);

                    $output = '';
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    // $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    // foreach ($data['statuses'] as $status) {
                    //     $output.=   '<tr>';
                    //     $output.=   '<td>' .substr($status['datetime'],0,-14). '</td>';                       
                    //     $output.=   '<td>' .$status['status']. '</td>';
                    //     $output.=   '<td>' .$status['comment']. '</td>';
                    //     $output.=   '</tr>';                            
                    // }             
                    $output.=   '</table>';
                }
            }


        // RGS LOGISTICS TRACKING
            else if ($courier == 'RGS Logistics') {
                $dvs_rgs_enable = get_option( 'dvs_rgs_enable' );
                if ($dvs_rgs_enable == 1 ) {

                    $get_dvs_rgs_email = get_option('dvs_rgs_email');
                    $get_dvs_rgs_password = get_option('dvs_rgs_password');

                   $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://codsolution.co/ship/Api/loginApi?email='.urlencode($get_dvs_rgs_email).'&password='.urlencode($get_dvs_rgs_password),
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 30,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_HTTPHEADER => array(),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $result = json_decode($response, true);

                    if($result['status'] == 'success') {

                        $bearer_token = $result['bearer_token'];

                        $curl = curl_init();
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://codsolution.co/ship/Api/track_parcel/?tracking_number='.$tracking,
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 30,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'GET',
                          CURLOPT_HTTPHEADER => array(
                            'Authorization: Bearer '.$bearer_token
                          ),
                        ));
                        $response = curl_exec($curl);
                        curl_close($curl);

                        $data = json_decode($response, true);

                        if (isset($data[0]['Status'])) {
                            $current_status = $data[0]['Status'];
                            $output = '';
                            $output.=   '<div class="order-details">';                 
                            $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                            $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                            $output.=   '</div>';
                            $output.=   '<div class="tracking-details">';                       
                            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
                            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                            $output.=   '</div>'; 
                            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                            $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                            foreach ($data as $status) {
                                $output.=   '<tr>';
                                $output.=   '<td>' .$status['date']. '</td>';
                                $output.=   '<td>' .$status['Status']. '</td>';
                                $output.=   '<td>' .$status['comment']. '</td>';
                                $output.=   '</tr>';                            
                            }             
                            $output.=   '</table>';
                        }
                        else {
                            echo "Courier: ".$courier;
                            echo "<br>";
                            echo "Tracking: ".$tracking;
                            echo "<br>";
                            echo 'Status: No result found<hr>Response:' . $response;
                        }                      
                    }
                }
            }






        // OSHI COURIER TRACKING
            else if ($courier == 'Oshi Courier') {
                $dvs_oshi_enable = get_option( 'dvs_oshi_enable' );
                if ($dvs_oshi_enable == 1 ) {

                    $dvs_oshi_code = get_option('dvs_oshi_code');
                    $dvs_oshi_api = get_option('dvs_oshi_api');

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://oshicourier.pk/trackingapiv2',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS =>'{
                        "clients": "'.$dvs_oshi_code.'",
                        "token": "'.$dvs_oshi_api.'",
                        "shipped_ref": "'.$tracking.'"
                    }',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                      ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    if (isset($data[0]['status'])) {
                        $current_status = end($data)['status'];
                        $output = '';
                        $output.=   '<div class="order-details">';                 
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        foreach ($data as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$status['createdon']. '</td>';
                            $output.=   '<td>' .$status['status']. '</td>';
                            $output.=   '<td></td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }                      
                }
            }




        // ROCKET COURIER TRACKING
            else if ($courier == 'Rocket Courier') {
                $dvs_rocket_enable = get_option( 'dvs_rocket_enable' );
                if ($dvs_rocket_enable == 1 ) {
                    $dvs_rocket_shipper_api = get_option( 'dvs_rocket_shipper_api' );
                    $rocket_tracking = $tracking;

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://app.couriermanager.eu/cscourier/API/get_history?api_key='.$dvs_rocket_shipper_api.'&awbno='.$rocket_tracking,
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    $current_status = trim(end($data['data']['history'])['description']);

                    $output = '';
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://rocketcourier.pk/tracking/" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    foreach ($data['data']['history'] as $status) {
                        $output.=   '<tr>';
                        $output.=   '<td>' .date('d-m-Y', $status['date']). '</td>';
                        $output.=   '<td>' .$status['description']. '</td>';
                        $output.=   '<td>' .$status['status']. '</td>';
                        $output.=   '</tr>';                            
                    }             
                    $output.=   '</table>';
                }
            }



        // COVERED LOGISTICS TRACKING
            else if ($courier == 'Covered Logistics') {
                $dvs_covered_enable = get_option( 'dvs_covered_enable' );
                if ($dvs_covered_enable == 1 ) {

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://api.covered.pk/api/v1/booking/trackParcel?cn='.$tracking,
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'GET',
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    if($data['statusCode'] == "200") {

                        $current_status = trim($data['data']['currentStatus']);

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="#" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        foreach ($data['data']['statesUpdates'] as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$status['timestamps']. '</td>';
                            $output.=   '<td>' .$status['status']. '</td>';
                            $output.=   '<td>' .$status['by']. '</td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }
                }
            }



        // COURIERS NEXT TRACKING
            else if ($courier == 'Couriers Next') {
                $dvs_acs_enable = get_option( 'dvs_csn_enable' );
                if ($dvs_acs_enable == 1 ) {

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://portal.couriersnext.com/API/TrackOrder.php',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS =>'{"tracking_no": "'.$tracking.'"}',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                        ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    if (!empty($data)) {

                        $current_status = trim(end($data)['status']);

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://panel.activecourier.pk/track-details.php?track_code='.$tracking.'" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        foreach ($data as $a) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$a['created']. '</td>';                       
                            $output.=   '<td>' .$a['status']. '</td>';
                            $output.=   '<td></td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }                    
                }
            }



        // COURIERS NEXT TRACKING
            else if ($courier == 'Zaaf Courier') {
                $dvs_zaaf_enable = get_option( 'dvs_zaaf_enable' );
                if ($dvs_zaaf_enable == 1 ) {

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://zaaf.pk/API/TrackOrder.php',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 10,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS =>'{"tracking_no": "'.$tracking.'"}',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                        ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    if ($data['message'] == "SUCCESS") {

                        $current_status = trim(end($data['delivery_info'])['status']);

                        $output = '';
                        $output.=   '<div class="order-details">';                       
                        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                        $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                        $output.=   '</div>';
                        $output.=   '<div class="tracking-details">';                       
                        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                        $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://panel.activecourier.pk/track-details.php?track_code='.$tracking.'" target="blank">' .$tracking. '</a></div>';
                        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                        $output.=   '</div>'; 
                        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                        $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                        foreach ($data['delivery_info'] as $status) {
                            $output.=   '<tr>';
                            $output.=   '<td>' .$status['datetime']. '</td>';                       
                            $output.=   '<td>' .$status['status']. '</td>';
                            $output.=   '<td></td>';
                            $output.=   '</tr>';                            
                        }             
                        $output.=   '</table>';
                    }
                    else {
                        echo "Courier: ".$courier;
                        echo "<br>";
                        echo "Tracking: ".$tracking;
                        echo "<br>";
                        echo 'Status: No result found<hr>Response:' . $response;
                    }                    
                }
            }



        // ACTIVE COURIER TRACKING
            else if ($courier == 'Active Courier') {
                $dvs_acs_enable = get_option( 'dvs_acs_enable' );
                if ($dvs_acs_enable == 1 ) {

                    // $acs_tracking = substr($tracking, 5);
                    // $curl = curl_init();
                    // curl_setopt_array($curl, array(
                    //   CURLOPT_URL => 'http://portal.activecourier.pk/api/v1/packet/'.$acs_tracking.'/status',
                    //   CURLOPT_RETURNTRANSFER => true,
                    //   CURLOPT_ENCODING => '',
                    //   CURLOPT_MAXREDIRS => 10,
                    //   CURLOPT_TIMEOUT => 10,
                    //   CURLOPT_FOLLOWLOCATION => true,
                    //   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    //   CURLOPT_CUSTOMREQUEST => 'GET',
                    // ));
                    // $response = curl_exec($curl);
                    // curl_close($curl);

                    $curl = curl_init();
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://panel.activecourier.pk/API/TrackOrder.php',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 30,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS =>'{"tracking_no": "'.$tracking.'"}',
                      CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json'
                        ),
                    ));
                    $response = curl_exec($curl);
                    curl_close($curl);

                    $data = json_decode($response, true);

                    $current_status = trim(end($data)['status']);

                    $output = '';
                    $output.=   '<div class="order-details">';                       
                    $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
                    $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
                    $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
                    $output.=   '</div>';
                    $output.=   '<div class="tracking-details">';                       
                    $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                    $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://panel.activecourier.pk/track-details.php?track_code='.$tracking.'" target="blank">' .$tracking. '</a></div>';
                    $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
                    $output.=   '</div>'; 
                    $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                    $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                    foreach ($data as $a) {
                        $output.=   '<tr>';
                        $output.=   '<td>' .$a['created']. '</td>';                       
                        $output.=   '<td>' .$a['status']. '</td>';
                        $output.=   '<td></td>';
                        $output.=   '</tr>';                            
                    }             
                    $output.=   '</table>';
                }
            }

        // RAPID COURIER TRACKING    
            // else if ($courier == 'Rapid Courier') {
            //     $rcs_api = get_option('dvs_rcs_shipper_api');      
            //     $dvs_rcs_url = 'https://app.couriermanager.eu/cscourier/API/get_info?api_key='.$rcs_api.'&awbno='.$tracking;
            //     $curl = curl_init();
            //     curl_setopt($curl, CURLOPT_URL, $dvs_rcs_url);
            //     curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);  
            //     curl_setopt($curl,CURLOPT_RETURNTRANSFER, true);
            //     $response = curl_exec($curl);
            //     curl_close($curl);
            //     $data = json_decode($response, true);
            //     $output = '';        
            //     $output.=   '<div class="order-details">';                       
            //     $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            //     $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            //     $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
            //     $output.=   '</div>';
            //     $output.=   '<div class="tracking-details">';                       
            //     $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            //     $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            //     $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            //     $output.=   '</div>'; 
            //     $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['data']['status']. '</div>';
            //     $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            //     foreach ($data['data'] as $a) {
            //         $output.=   '<tr>';
            //         $output.=   '<td></td>';                       
            //         $output.=   '<td>' .$a['status']. '</td>';
            //         $output.=   '<td></td>';
            //         $output.=   '</tr>';                            
            //     }             
            //     $output.=   '</table>';
            // }
            // else if ($courier == 'DCS Courier' && $print) {
            //     $dvs_tracking_link = "http://dcscourier.com/Tracking";
            //     echo '<div class="dvs-100">';
            //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
            //     echo '</div>';
            // }
            // else if ($courier == 'Pace Courier' && $print) {
            //     $dvs_tracking_link = "https://pacecourierservice.com/tracking.php";
            //     echo '<div class="dvs-100">';
            //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
            //     echo '</div>';
            // }   
            // else if ($courier == 'Pakistan Post' && $print) {
            //     $dvs_tracking_link = "http://ep.gov.pk/";
            //     echo '<div class="dvs-100">';
            //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
            //     echo '</div>';
            // }
            // else if ($courier == 'DHL' && $print) {
            //     $dvs_tracking_link = "https://www.dhl.com/en/express/tracking.html?AWB=".$dvs_courier_tracking."&brand=DHL";
            //     echo '<div class="dvs-100">';
            //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
            //     echo '</div>';
            // }
            // else if ($courier == 'FedEx' && $print) {
            //     $dvs_tracking_link = "https://www.fedex.com/apps/fedextrack/?action=track";
            //     echo '<div class="dvs-100">';
            //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
            //     echo '</div>';
            // }
            // else if ($courier == 'SkyNet' && $print) {
            //     $dvs_tracking_link = "https://sky.skynet.net/public/Tracking.aspx?guide=".$dvs_courier_tracking."";
            //     echo '<div class="dvs-100">';
            //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
            //     echo '</div>';
            // }       
            else {
                $output = 'Live Tracking Not Available';
            }


            $dvs_current_datetime = current_time('mysql');


            // IF HAVE STATUS
            if(!empty($current_status)) {

                update_post_meta( $order_id, '_dvs_courier_status', $current_status );
                $dbData = array();
                $dbData['courier_delivery'] = $current_status;
                $wpdb->update('dvs_ucp_logs', $dbData, array('courier_tracking' => $tracking));

                $current_status = trim($current_status);
                $current_status = strtolower($current_status);

                $dvs_courier_datetime = get_post_meta( $order_id, '_dvs_courier_datetime', true );
                $dvs_shipped_datetime = get_post_meta( $order_id, '_dvs_shipped_datetime', true );
                $dvs_received_datetime = get_post_meta( $order_id, '_dvs_received_datetime', true );

               if(empty($dvs_courier_datetime)) {
                    $sql_courier_datetime = $wpdb->get_row("SELECT `courier_datetime` FROM dvs_ucp_logs WHERE courier_tracking = '$tracking'");
                    $dvs_courier_datetime = $sql_courier_datetime->courier_datetime;
                    update_post_meta($order_id, '_dvs_courier_datetime', $dvs_courier_datetime);
                }                       

                if(empty($current_status)) {
                    // DO NOTHING
                }
                else if($current_status == "uncollected" || $order_status == 'completed' || $order_status == 'cancelled' || $order_status == 'refunded' || $order_status == 'lost' || $order_status == 'logistic-claim' || $order_status == 'paymentreceived') {
                    // DO NOTHING
                }
                else if( $current_status == "shipment returned to shipper" || $current_status == "return to origin" || $current_status == "return to sender" || $current_status == "received code: returned to shipper" || $current_status == "return to shipper" || $current_status == "returned to shipper" || $current_status == "return - delivered to shipper" || $current_status == "return submitted" || $current_status == "returned to vendor" || $current_status == "returned at merchant warehouse" || $current_status == "delivered to shipper" || $current_status == "return shipment delivered to customer" || $current_status == "returned") {
                    $dbData = array();
                    $dbData['courier_status'] = 'returned';
                    if(empty($dvs_received_datetime)) {
                        $dbData['received_datetime'] = $dvs_current_datetime;
                        update_post_meta($order_id, '_dvs_received_datetime', $dvs_current_datetime );
                    }                    
                    $wpdb->update('dvs_ucp_logs', $dbData, array('courier_tracking' => $tracking));
                    if($dvs_label_shipper_returned == 1) {
                        $order->update_status( 'wc-returned' );
                    }
                }
                else if (preg_match("~\bdrop off|arrived|unload|unloading|in_transit|ops|re_attempt_requested|unsuccessful|picked up|parcel received at office|out for delivery|dispatch|picked up|enroute for delivery|received at|waiting for delivery|departed|transit|hold|courier out|shipment picked|rfc_origin|out for delivery|dispatched|out for|is out|moved to|reached at|on route|reached|reached blueex|picked up|at swyft|assign|assigned|at postex|on route|depart|is physically|arrival|collected|pickup request sent|self collection|undelivered|scheduled|loaded|loading|bagged|picked_up|debag|received_at_fc|en-route\b~",$current_status)) {
                    $dbData = array();
                    $dbData['courier_status'] = 'shipped';
                    if(empty($dvs_shipped_datetime)) {
                        $dbData['shipped_datetime'] = $dvs_current_datetime;
                        update_post_meta($order_id, '_dvs_shipped_datetime', $dvs_current_datetime );
                    }                   
                    $wpdb->update('dvs_ucp_logs', $dbData, array('courier_tracking' => $tracking));
                    if($dvs_label_shipper_shipped == 1) {
                        if($order_status != 'delivered' && $order_status != 'returned' && $order_status != 'return') {
                            $order->update_status( 'wc-shipped' );
                        }
                    }
                }
                else if ( preg_match("~\brefuse|refused|rfd|rider cancelled\b~",$current_status) ) {
                    $dbData = array();
                    $dbData['courier_status'] = 'refused';
                    $wpdb->update('dvs_ucp_logs', $dbData, array('courier_tracking' => $tracking));
                    if($dvs_label_shipper_refused == 1) {
                        $order->update_status( 'wc-refused' );
                    }           
                }             
                else if ( preg_match("~\bdeliver|delivered\b~",$current_status) && ! preg_match("~\bdelivery|undeliver|undelivered|un-delivered\b~",$current_status) ) {
                    $dbData = array();
                    $dbData['courier_status'] = 'delivered';
                    if(empty($dvs_received_datetime)) {
                        $dbData['received_datetime'] = $dvs_current_datetime;
                        update_post_meta($order_id, '_dvs_received_datetime', $dvs_current_datetime );
                    }
                    $wpdb->update('dvs_ucp_logs', $dbData, array('courier_tracking' => $tracking));
                    if($dvs_label_shipper_delivered == 1) {
                        $order->update_status( 'wc-delivered' );
                    }           
                }                
                else if ( preg_match("~\bcancel|cancelled|canceled|un-assigned\b~",$current_status) ) {
                    $dbData = array();
                    $dbData['courier_status'] = 'cancelled';
                    $wpdb->update('dvs_ucp_logs', $dbData, array('courier_tracking' => $tracking));          
        		}
        		else {
                    // DO NOTHING               	
        		}

                $dvs_shipped_datetime = get_post_meta( $order_id, '_dvs_shipped_datetime', true );
                $dvs_received_datetime = get_post_meta( $order_id, '_dvs_received_datetime', true );

                if($dvs_received_datetime && $dvs_shipped_datetime ) {
                    $dvs_parcel_days = floor((strtotime($dvs_received_datetime) - strtotime($dvs_shipped_datetime)) / (60 * 60 * 24));
                    update_post_meta($order_id, '_dvs_parcel_days', $dvs_parcel_days );
                }
                else if ($dvs_shipped_datetime ) {
                    $dvs_parcel_days = floor((strtotime($dvs_current_datetime) - strtotime($dvs_shipped_datetime)) / (60 * 60 * 24));
                    update_post_meta($order_id, '_dvs_parcel_days', $dvs_parcel_days );
                }
                else {
                }                  

        		// OUTPUT PRINT
                if ($print) {
                    echo $output;
                }
            }
        }
    }
}