<?php
/**
 * Order tracking form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/form-tracking.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $post;

$dvs_ucp_track_phone = get_option( 'dvs_ucp_track_phone' );
$dvs_ucp_track_cn = get_option( 'dvs_ucp_track_cn' );

?>

<style>
	#dvs-tracker {
	    background: #fff !important;
	    padding: 2rem !important;
	    border-radius: 8px !important;
	    box-shadow: 0 4px 8px rgba(0,0,0,0.1) !important;
	    width: 480px !important;
	    margin: 0 auto !important;
	}
	.dvs-head {
		font-size: 18px !important;
	    font-weight: bold !important;
	    font-size: 1.5rem !important;
	    color: #333 !important;
	    margin-bottom: 1rem !important;
	    text-align: center !important;
	}
	.dvs-tabs {
	    display: flex !important;
	    justify-content: space-between !important;
	    margin-bottom: 2rem !important;
	}
	.dvs-tab {
		font-size: 16px !important;
	    width: 50% !important;
	    text-align: center !important;
	    padding-bottom: .5rem !important;
	    cursor: pointer !important;
	    font-weight: bold !important;
	    color: #888 !important;
	    transition: color 0.3s !important;
	}
	.dvs-tab.active {
	    color: #333 !important;
	    border-bottom: 2px solid #333 !important;
	}
	.dvs-input-field {
		font-size: 14px !important;
	    width: 100% !important;
	    height: unset !important;
	    padding: 15px 10px !important;
	    border-radius: 4px !important;
	    box-sizing: border-box !important;
	    margin-bottom: 1rem !important;
	    border: 1px solid #d2d6dc !important;
	    background-color: #fff !important;
	    box-shadow: 0 1px 2px 0 rgba(0,0,0,.05) !important;        
	}
	.dvs-input-field:focus {
	    outline: none !important;
	    border-color: #a0a0a0 !important;
	}
	.dvs-track-btn {
	    width: 100% !important;
	    padding: 15px !important;
	    background-color: #333 !important;
	    color: white !important;
	    border: none !important;
	    border-radius: 4px !important;
	    cursor: pointer !important;
	    transition: background-color 0.3s !important;
	    line-height: unset !important;
	}
	.dvs-track-btn:hover {
	    background-color: #555 !important;
	}
	.dvs-tab-content {
	    display: none !important;
	}
	.dvs-tab-content.active {
	    display: block !important;
	}
	/* Media query for tablet and mobile devices */
	@media (max-width: 999px) {
	    #dvs-tracker {
	        width: auto !important;
			padding: 1rem !important;
	    }
		.dvs-tab {
			font-size: 14px !important;
		}
	}	
</style>

<form action="<?php echo esc_url( get_permalink( $post->ID ) ); ?>" method="post" class="woocommerce-form woocommerce-form-track-order track_order">


<div id="dvs-tracker">
    <div class="dvs-head">Track Your Order</div>
    <div class="dvs-tabs">
        <div class="dvs-tab active" onclick="dvsOpenTab(event, 'dvs-orderNumberTab')">Order Number</div>
        <div class="dvs-tab" onclick="dvsOpenTab(event, 'dvs-trackingNumberTab')">Tracking Number</div>
    </div>
    <div id="dvs-orderNumberTab" class="dvs-tab-content active">
    	<input type="text" name="orderid" id="orderid" class="dvs-input-field" placeholder="Order Number" value="">

		<?php if($dvs_ucp_track_phone == 1 ) { ?>
        	<input type="tel" name="order_phone" id="order_phone" class="dvs-input-field" placeholder="Mobile Number" value="">
		<?php }
		else { ?>        
			<input type="email" name="order_email" id="order_email" class="dvs-input-field" placeholder="Email Address" value="">
		<?php } ?>
        <button class="dvs-track-btn" name="track">TRACK</button>
    </div>
    <div id="dvs-trackingNumberTab" class="dvs-tab-content">
        <input type="text" name="order_tracking" id="order_tracking" class="dvs-input-field" placeholder="Tracking Number" value="">
        <button class="dvs-track-btn" name="track">TRACK</button>
    </div>
</div>
	<?php wp_nonce_field( 'woocommerce-order_tracking', 'woocommerce-order-tracking-nonce' ); ?>
</form>


<script>
function dvsOpenTab(evt, tabName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("dvs-tab-content");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].classList.remove("active");
    }
    tablinks = document.getElementsByClassName("dvs-tab");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].classList.remove("active");
    }
    document.getElementById(tabName).classList.add("active");
    evt.currentTarget.classList.add("active");
}

function dvsTrackOrder() {
    // Placeholder for tracking functionality
    alert('DVS Tracking functionality is not implemented.');
}
</script>

</body>
</html>