<?php


if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_swyft_plugin_settings' );
function dvs_swyft_plugin_settings() {
	register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_enable' );
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_vendor' );	
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_api' );
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_pickup' );     
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_origin' );
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_type' );     
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_handling' );           
	register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_consignee' );
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_product' );	      
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_remarks' );
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_product_check' );     
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_sku_check' );
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_notes_check' );
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_weight_check' );    
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_pieces_check' );    
    register_setting( 'dvs-swyft-settings-group', 'dvs_swyft_cod_check' );                            
}

//Courier settings input fields
function dvs_swyft_api_page() { ?>
<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-swyft-settings-group' );
	do_settings_sections( 'dvs-swyft-settings-group' );
    $dvs_swyft_pickup = get_option('dvs_swyft_pickup');
	$dvs_swyft_origin = get_option('dvs_swyft_origin');
	$dvs_swyft_type = get_option('dvs_swyft_type');
	$dvs_swyft_handling = get_option('dvs_swyft_handling');
	$dvs_swyft_consignee = get_option('dvs_swyft_consignee');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/swyft-label-logo.png'; ?>" height="50px">
    <h2>Swyft Logistics Settings</h2>
    <table class="form-table">

        <tr>
        <th scope="row">Enable Swyft Logistics API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_swyft_enable" value="1" ' . checked( 1, get_option( 'dvs_swyft_enable' ), false ) . ' />';?>
        </td>
        </tr> 

        <tr>
        <th scope="row">Vendor ID</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_swyft_vendor" value="<?php echo esc_attr( get_option('dvs_swyft_vendor') ); ?>" /></td>
        </tr>

        <tr>
        <th scope="row">API Secret</th>
        <td><input class="regular-text" placeholder="" type="password" name="dvs_swyft_api" value="<?php echo esc_attr( get_option('dvs_swyft_api') ); ?>" /></td>
        </tr>

        <?php

        $get_dvs_swyft_vendor = get_option('dvs_swyft_vendor');
        $get_dvs_swyft_api = get_option('dvs_swyft_api');

        if (!empty($get_dvs_swyft_vendor) && !empty($get_dvs_swyft_api) ) {

            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://vendor-api.swyft-logistics.com/api/'.$get_dvs_swyft_vendor.'/pickup-locations',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 10,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
              CURLOPT_HTTPHEADER => array(
                'Authorization: '.$get_dvs_swyft_api
              ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            $result = json_decode($response, true);

            if(!empty($result[0]['shortId'])) {

            ?>

                <tr>
                <th scope="row">Pickup Address</th>
                <td><select id="dvs_swyft_pickup" name="dvs_swyft_pickup" >
                    <?php
                    foreach ($result as $pickup) { ?>
                        <option value="<?php echo $pickup['id'] ?>" <?php selected($dvs_swyft_pickup, $pickup['id']); ?>><?php echo $pickup['address'] ?></option>
                    <?php } ?></td>
                </select>
                </tr>      

                <tr>
                <th scope="row">Shipper Origin</th>
                <td>
        			<select id="dvs_swyft_origin" name="dvs_swyft_origin" >
        				<option value="LHE" <?php selected($dvs_swyft_origin,'LHE'); ?>>Lahore</option>
        				<option value="KHI" <?php selected($dvs_swyft_origin,'KHI'); ?>>Karachi</option>
        				<option value="ISB" <?php selected($dvs_swyft_origin,'ISB'); ?>>Islamabad</option>
        				<option value="RWP" <?php selected($dvs_swyft_origin,'RWP'); ?>>Rawalpindi</option>
        				<option value="SKP" <?php selected($dvs_swyft_origin,'SKP'); ?>>Sheikhupura</option>
        				<option value="LYP" <?php selected($dvs_swyft_origin,'LYP'); ?>>Faisalabad</option>	
        				<option value="KSR" <?php selected($dvs_swyft_origin,'KSR'); ?>>Kasur</option>
        				<option value="GUJ" <?php selected($dvs_swyft_origin,'GUJ'); ?>>Gujranwala</option>
        				<option value="SKT" <?php selected($dvs_swyft_origin,'SKT'); ?>>Sialkot</option>
                        <option value="GRT" <?php selected($dvs_swyft_origin,'GRT'); ?>>Gujrat</option>								
                    </select>
                <td>        
                </tr>	        
         
                <tr>
                <th scope="row">Shipment Type</th>
                <td>
                    <select id="dvs_swyft_type" name="dvs_swyft_type" >
                    	<option value="COD" <?php selected($dvs_swyft_type,'COD'); ?>>COD</option>
                    	<option value="NONCOD" <?php selected($dvs_swyft_type,'NONCOD'); ?>>NON COD</option>

                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Shipment Handling</th>
                <td>
                    <select id="dvs_swyft_handling" name="dvs_swyft_handling" >
                    	<option value="Yes" <?php selected($dvs_swyft_handling,'Yes'); ?>>Fragile</option>
                    </select>
                <td>        
                </tr>        

                <tr>
                <th scope="row">Consginee Details</th>
                <td>
                    <select id="dvs_swyft_consignee" name="dvs_swyft_consignee" >
                    <option value="Billing Details" <?php selected($dvs_swyft_consignee,'Billing Details'); ?>>Billing Details</option>
                    <option value="Shipping Details" <?php selected($dvs_swyft_consignee,'Shipping Details'); ?>>Shipping Details</option>
                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Default Remarks</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_swyft_remarks" value="<?php echo esc_attr( get_option('dvs_swyft_remarks') ); ?>" required="true"/></td>
                </tr>  

                <tr>
                <th scope="row">Default Product</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_swyft_product" value="<?php echo esc_attr( get_option('dvs_swyft_product') ); ?>" /></td>
                </tr>  

                <tr>
                <th scope="row">Print Item Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_swyft_product_check" value="1" ' . checked( 1, get_option( 'dvs_swyft_product_check' ), false ) . ' />';?>
                </td>
                </tr>

                <tr>
                <th scope="row">Print SKU Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_swyft_sku_check" value="1" ' . checked( 1, get_option( 'dvs_swyft_sku_check' ), false ) . ' />';?>
                </td>
                </tr>

                <tr>
                <th scope="row">Print Order Notes in Remarks</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_swyft_notes_check" value="1" ' . checked( 1, get_option( 'dvs_swyft_notes_check' ), false ) . ' />';?>
                </td>
                </tr> 

                <tr>
                <th scope="row">Auto Calculate Weight</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_swyft_weight_check" value="1" ' . checked( 1, get_option( 'dvs_swyft_weight_check' ), false ) . ' />';?>
                </td>
                </tr>               

                <tr>
                <th scope="row">Auto Calculate Pieces</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_swyft_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_swyft_pieces_check' ), false ) . ' />';?>
                </td>
                </tr>

                <tr>
                <th scope="row">Calculate Non-COD as Zero</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_swyft_cod_check" value="1" ' . checked( 1, get_option( 'dvs_swyft_cod_check' ), false ) . ' />';?>
                </td>
                </tr>
                
            <?php
           }
            else {
                echo '<div class="notice notice-error is-dismissible"><p>Error: Invalid Vendor ID or API Secret. Please contact support: 03234152099</p></div>';
            }
       }
        ?>                             

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<a href="https://www.youtube.com/watch?v=Cp_1Uga4W7I" target="blank" class="woocommerce-Button button">Video: How to configure Swyft Logistics Settings</a>
<br>
<br>
<a href="https://devsol.pk/contact/" target="blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}



function dvs_swyft_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',
        );
    }

    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );
    return $orders_data;
}



function dvs_swyft_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'Swyft Logistics',
        'dvs_slug' => 'swyft',
        'dvs_type' => get_option( 'dvs_swyft_type' ),
        'dvs_handling' => get_option( 'dvs_swyft_handling' ),
        'dvs_consignee' => get_option( 'dvs_swyft_consignee' ),
        'dvs_remarks' => get_option( 'dvs_swyft_remarks' ),
        'dvs_product' => get_option( 'dvs_swyft_product' ),
        'dvs_product_check' => get_option( 'dvs_swyft_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_swyft_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_swyft_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_swyft_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_swyft_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_swyft_cod_check' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'swyft_bulk_actions',101 );
function swyft_bulk_actions( $bulk_array ) {
    $dvs_swyft_enable = get_option( 'dvs_swyft_enable' );
    if ($dvs_swyft_enable == 1 ) {
        $bulk_array['mark_swyft_orders'] = 'Swyft Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_swyft_bulk_action_handler', 10, 4 );
function dvs_swyft_bulk_action_handler( $redirect, $doaction, $object_ids ) {
	if ( $doaction !== 'mark_swyft_orders' ) {
	    return $redirect;
	}
    $orders_data = [];
    $orders_items = [];
	foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_swyft_orders_data($order_id);

    }
    dvs_swyft_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'swyft_single_order_action', 10, 1 );
function swyft_single_order_action( $actions ) {
    $dvs_swyft_enable = get_option( 'dvs_swyft_enable' );
    if ($dvs_swyft_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['swyft_action'] = __( 'Book at Swyft Logistics' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_swyft_action', 'swyft_single_order_booking' );
function swyft_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_swyft_orders_data($order_id);
    dvs_swyft_body_data($orders_data);
    die();
}


add_action( 'init', 'swyft_submit_form' );
function swyft_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'swyft' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "SWYFT",
				'dvs_swyft_vendor' => get_option('dvs_swyft_vendor'),				
				'dvs_swyft_api' => get_option('dvs_swyft_api'),
				'dvs_swyft_origin'	=>  get_option('dvs_swyft_origin'),				
				'dvs_swyft_pickup'	=>  get_option('dvs_swyft_pickup'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  
            $current_order = $order;

            if (!empty($response['data'][0]['parcelId'])) {
                $order = new WC_Order($order_id);
                $swyft_tracking = $response['data'][0]['parcelId'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$swyft_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at Swyft Logistics with Tracking # ".$swyft_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'Swyft Logistics');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $swyft_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $swyft_tracking, 'Swyft Logistics');

                $trackings[] = $swyft_tracking;
                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }    

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/swyft-label-logo.png'; ?>" height="50px">    
            <h3>Swyft Logistics Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }

            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_swyft = get_option( 'dvs_courier_swyft' ) + $count ;
        update_option('dvs_courier_swyft', $dvs_courier_swyft);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'SWYFT',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}


