<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// Add Tracking meta box
add_action( 'add_meta_boxes', 'dvs_tracking_box' );
function dvs_tracking_box() {
    add_meta_box(
        'dvs-tracking-modal',
        'Shipment Details',
        'dvs_tracking_meta_box_callback',
        'shop_order',
        'side',
        'core'
    );
}

// Callback
function dvs_tracking_meta_box_callback( $post ) {
    $dvs_courier_list = get_post_meta($post->ID, '_dvs_courier_list', true);
    $dvs_courier_tracking = get_post_meta( $post->ID, '_dvs_courier_tracking', true );
	$dvs_courier_slip = get_post_meta( $post->ID, '_dvs_courier_slip', true );
    $dvs_courier_check = get_post_meta( $post->ID, '_dvs_courier_check', true );
    echo '<input type="hidden" name="dvs_tracking_box_nonce" value="' . wp_create_nonce() . '">';
?>
    <select name="dvs_courier_check" id="dvs_courier_check" class="postbox">
        <option value="Un-Booked" <?php selected($dvs_courier_check, 'Un-Booked'); ?>>Un-Booked</option>
        <option value="Booked" <?php selected($dvs_courier_check, 'Booked'); ?>>Booked</option>            
    </select>
    <select name="dvs_courier_list" id="dvs_courier_list" class="postbox">
        <option value="">Select Courier</option>
        <option value="TCS" <?php selected($dvs_courier_list, 'TCS'); ?>>TCS</option>
        <option value="Leopards Courier" <?php selected($dvs_courier_list, 'Leopards Courier'); ?>>Leopards Courier</option>
        <option value="Trax" <?php selected($dvs_courier_list, 'Trax'); ?>>Trax</option>        
        <option value="MNP" <?php selected($dvs_courier_list, 'MNP'); ?>>MNP</option>
        <option value="Call Courier" <?php selected($dvs_courier_list, 'Call Courier'); ?>>Call Courier</option>
        <option value="BlueEx" <?php selected($dvs_courier_list, 'BlueEx'); ?>>BlueEx</option>        
        <option value="Daewoo Courier" <?php selected($dvs_courier_list, 'Daewoo Courier'); ?>>Daewoo Courier</option>
        <option value="PostEx" <?php selected($dvs_courier_list, 'PostEx'); ?>>PostEx</option>
        <option value="Insta World" <?php selected($dvs_courier_list, 'Insta World'); ?>>Insta World</option>
        <option value="Do Deliver" <?php selected($dvs_courier_list, 'Do Deliver'); ?>>Do Deliver</option>
        <option value="Rider" <?php selected($dvs_courier_list, 'Rider'); ?>>Rider</option>
        <option value="Oshi Courier" <?php selected($dvs_courier_list, 'Oshi Courier'); ?>>Oshi Courier</option>    
        <option value="Zaaf Courier" <?php selected($dvs_courier_list, 'Zaaf Courier'); ?>>Zaaf Courier</option>        
        <option value="Couriers Next" <?php selected($dvs_courier_list, 'Couriers Next'); ?>>Couriers Next</option>  
        <option value="AHL Courier" <?php selected($dvs_courier_list, 'AHL Courier'); ?>>AHL Courier</option>
        <option value="Rocket Courier" <?php selected($dvs_courier_list, 'Rocket Courier'); ?>>Rocket Courier</option>
        <option value="Falcomail" <?php selected($dvs_courier_list, 'Falcomail'); ?>>Falcomail</option>
        <option value="Ship NOC" <?php selected($dvs_courier_list, 'Ship NOC'); ?>>Ship NOC</option>
        <option value="RGS Logistics" <?php selected($dvs_courier_list, 'RGS Logistics'); ?>>RGS Logistics</option>
        <option value="Covered Logistics" <?php selected($dvs_courier_list, 'Covered Logistics'); ?>>Covered Logistics</option>
        <option value="Active Courier" <?php selected($dvs_courier_list, 'Active Courier'); ?>>Active Courier</option>
        <option value="Swyft Logistics" <?php selected($dvs_courier_list, 'Swyft Logistics'); ?>>Swyft Logistics</option>   
        <option value="Pakistan Post" <?php selected($dvs_courier_list, 'Pakistan Post'); ?>>Pakistan Post</option>
    </select>

    <input style="width:100%;" type="text" name="dvs_courier_tracking" id="dvs_courier_tracking" placeholder="Tracking #" value="<?php echo $dvs_courier_tracking;?>"/> 

<?php   add_thickbox();

    if(!empty($dvs_courier_list) && !empty($dvs_courier_tracking)) { 

        echo'<a href="#TB_inline?width=650&height=600&inlineId=dvs-content-track" class="button-primary thickbox" onclick="dvstrackparcel(\'' . $post->ID . '\', \'' . $dvs_courier_list . '\', \'' . $dvs_courier_tracking . '\')" style="width: 70%; text-align:center; margin: 20px 0px 0px 0px; background-color: #2271b1; border-color: #2271b1;color:#ffffff">Track Shipment</a>';

        echo'<a href="#TB_inline?width=400&height=300&inlineId=dvs-content-cancel" class="button-primary thickbox" onclick="dvscancelparcel(\'' . $post->ID . '\', \'' . $dvs_courier_list . '\', \'' . $dvs_courier_tracking . '\')" style="width: 25%; text-align:center; margin: 20px 0px 0px 5%; background-color: #ff4e4e; border-color: #ff4e4e; color:#ffffff">Cancel</a>';


        $dvs_ucp_display_average = get_option( 'dvs_ucp_display_average' );
        if($dvs_ucp_display_average == 1 ) {
            $dvs_courier_status = get_post_meta( $post->ID, '_dvs_courier_status', true );
            $dvs_courier_datetime = get_post_meta( $post->ID, '_dvs_courier_datetime', true );
            $dvs_shipped_datetime = get_post_meta( $post->ID, '_dvs_shipped_datetime', true );
            $dvs_received_datetime = get_post_meta( $post->ID, '_dvs_received_datetime', true );
            $dvs_parcel_days        = get_post_meta( $post->ID, '_dvs_parcel_days', true );
            if($dvs_courier_status) {
                echo '<hr>';
                echo '<strong>Status:</strong> ' . $dvs_courier_status;
                echo '<hr>';
            }            
            if($dvs_courier_datetime) {
                echo '<strong>Booked:</strong> ' . date('d-m-Y', strtotime($dvs_courier_datetime));
            }
            if($dvs_shipped_datetime) {
                echo '<br><strong>Shipped:</strong> ' . date('d-m-Y', strtotime($dvs_shipped_datetime));
            }
            if($dvs_received_datetime) {
                echo '<br><strong>Received:</strong> ' . date('d-m-Y', strtotime($dvs_received_datetime));
            }
            if($dvs_parcel_days) {
                echo '<br><strong>Duration:</strong> ' . $dvs_parcel_days . ' Days';
            }
        }
    }
    ?>
    <style>
        #TB_ajaxContent {
            width: 90% !important;
            margin: 0 auto !important;
        }
    </style>

    <div id="dvs-content-track" style="display:none;">
        <div class="track-thickbox">
            <center><img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/loader.gif'; ?>"></center>
        </div>
    </div>

    <div id="dvs-content-cancel" style="display:none;">
        <div class="cancel-thickbox">
            <center><img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/loader.gif'; ?>"></center>
        </div>
    </div>

    <script type='text/javascript'>
    function dvscancelparcel(orderId, courier, tracking) {
        var answer = window.confirm("Important: Please click OK to cancel this shipment");
        if (answer) {
            loading = "<center><img src=\"<?php echo plugin_dir_url( __DIR__ ) . 'images/loader.gif'; ?>\"></center>"
            jQuery(".cancel-thickbox").html(loading);
            jQuery.ajax({
                type: 'POST',
                url: '<?php echo admin_url('/admin-ajax.php'); ?>',
                data: {
                    'action':   'dvs_courier_cancel_tracking',
                    'dvs_order_id' : orderId,
                    'dvs_courier_list' : courier,                                     
                    'dvs_courier_tracking' : tracking,
                },                     
                success: function (response) {
                //  console.log(response);
                    jQuery(".cancel-thickbox").html(response);
                }                
            });
        }
        else {
            jQuery(".cancel-thickbox").html('<p>Note: This shipment is not cancelled.</p>');
        }
    }
    </script>
<?php 
}


add_action( 'save_post', 'dvs_tracking_save_meta_box_data' );
function dvs_tracking_save_meta_box_data( $post_id ) {
    if ( isset($_POST[ 'post_type' ]) && 'shop_order' != $_POST[ 'post_type' ] )
        return $post_id;
    if ( ! isset( $_POST[ 'dvs_tracking_box_nonce' ] ) )
        return $post_id;

    $nonce = $_POST[ 'dvs_tracking_box_nonce' ];
    if ( ! wp_verify_nonce( $nonce ) )
        return $post_id;
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
        return $post_id;
    if ( ! current_user_can( 'edit_shop_order', $post_id ) && ! current_user_can( 'edit_shop_orders', $post_id ) )
        return $post_id;
    update_post_meta( $post_id, '_dvs_courier_list', sanitize_text_field( $_POST[ 'dvs_courier_list' ] ) );   
    update_post_meta( $post_id, '_dvs_courier_tracking', sanitize_text_field( $_POST[ 'dvs_courier_tracking' ] ) );  
    update_post_meta( $post_id, '_dvs_courier_check', sanitize_text_field( $_POST[ 'dvs_courier_check' ] ) );   
}
