<?php

if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_shipper_plugin_settings' );
function dvs_shipper_plugin_settings() {
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_booked' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_shipped' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_delivered' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_refused' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_returned' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_ucp_cron_track_time' );
	register_setting( 'dvs-shipper-settings-group', 'dvs_ucp_courier_pagination' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_enable' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_logo' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_size' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_order_display' );                              
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_name_1' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_phone_1' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_address_1' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_city_1' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_name_2' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_phone_2' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_address_2' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_city_2' );  
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_name_3' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_phone_3' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_address_3' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_label_shipper_city_3' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_ucp_track_phone' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_ucp_wa_tracking_text' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_ucp_track_cn' );
    register_setting( 'dvs-shipper-settings-group', 'dvs_ucp_display_average' );
}

//Courier settings input fields
function dvs_label_shipper_page() { ?>
<div class="wrap">
<form method="post" action="options.php">
    <?php 
    settings_fields( 'dvs-shipper-settings-group' );
    do_settings_sections( 'dvs-shipper-settings-group' );
    $dvs_label_shipper_size = get_option('dvs_label_shipper_size');
    $dvs_label_shipper_order_display = get_option('dvs_label_shipper_order_display');
    $dvs_ucp_cron_track_time = get_option('dvs_ucp_cron_track_time');
    ?>
    <h2>Shipper Settings</h2>
    <table class="form-table">

        <tr>
            <th scope="row">Enable Auto Courier Tracking</th>
            <td>
                <select id="dvs_ucp_cron_track_time" name="dvs_ucp_cron_track_time" required>
                    <option value="disabled" <?php selected($dvs_ucp_cron_track_time,'disabled'); ?>>Disabled</option>
                    <option value="28800" <?php selected($dvs_ucp_cron_track_time,'28800'); ?>>Every 8 Hours</option>
                    <option value="43200" <?php selected($dvs_ucp_cron_track_time,'43200'); ?>>Every 12 Hours</option>
                    <option value="86400" <?php selected($dvs_ucp_cron_track_time,'86400'); ?>>Every 24 Hours</option>
                </select>
                <br><br><small>Note: Make sure your cron settings are not disabled in wp-config file and increase max_execution_time to 300</small>
            <td>        
        </tr>

        <tr>
            <th scope="row">Auto Booked Order Status</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_label_shipper_booked" value="1" ' . checked( 1, get_option( 'dvs_label_shipper_booked' ), false ) . ' />';?>
            </td>
        </tr> 

        <tr>
            <th scope="row">Auto Shipped Order Status</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_label_shipper_shipped" value="1" ' . checked( 1, get_option( 'dvs_label_shipper_shipped' ), false ) . ' />';?>
            </td>
        </tr>         

        <tr>
        <th scope="row">Auto Delivered Order Status</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_label_shipper_delivered" value="1" ' . checked( 1, get_option( 'dvs_label_shipper_delivered' ), false ) . ' />';?>
            </td>
        </tr> 

        <tr>
            <th scope="row">Auto Refused Order Status</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_label_shipper_refused" value="1" ' . checked( 1, get_option( 'dvs_label_shipper_refused' ), false ) . ' />';?>
            </td>
        </tr> 

        <tr>
            <th scope="row">Auto Returned Order Status</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_label_shipper_returned" value="1" ' . checked( 1, get_option( 'dvs_label_shipper_returned' ), false ) . ' />';?>
            </td>
        </tr>

        <tr>
            <th scope="row">Display Logs Per Page</th>
            <td>
                <input class="regular-text" placeholder="" type="number" min="50" max="500" name="dvs_ucp_courier_pagination" value="<?php echo esc_attr( get_option('dvs_ucp_courier_pagination') ); ?>" />
            </td>
        </tr>

        <tr style="border-top: 1px solid #cccccc">
            <th scope="row">WhatsApp Tracking Text
        <small style="font-size:10px;font-weight:400;"><br><br>
            [order_number]<br>
            [customer_name]<br>
            [courier_name]<br>
            [courier_tracking]<br>
            [courier_link]<br>
        </small>
            </th>
            <td>
                <textarea class="regular-text" name="dvs_ucp_wa_tracking_text" rows="5"><?php echo esc_textarea( get_option('dvs_ucp_wa_tracking_text') ); ?></textarea>
                <br><small style="font-size: 10px;">Note: This text is use in WhatsApp text. Please use variables for customization.</small>
                <br><small style="font-size: 10px;">Sample: Dear [customer_name], your order [order_number] has been shipped. Courier is [courier_name] with Tracking [courier_tracking]. Get Live Tracking: [courier_link]  
                </small>                
            </td>
        </tr>

        <tr style="border-top: 1px solid #cccccc">
            <th scope="row">Customer Track Page</th>
            <td>To enable tracking for customer, create a new page and add this shortcode: [dvs_order_tracking]. Watch the <a href="https://www.youtube.com/watch?v=Ml34che2IDA&t=576s" target="_blank">video guide</a>
            </td>
        </tr>

        <tr>
            <th scope="row">Track by Mobile Number</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_ucp_track_phone" value="1" ' . checked( 1, get_option( 'dvs_ucp_track_phone' ), false ) . ' />';?>
            </td>
        </tr>

        <tr>
            <th scope="row">Display Shipment Timeline</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_ucp_display_average" value="1" ' . checked( 1, get_option( 'dvs_ucp_display_average' ), false ) . ' />';?>
            </td>
        </tr>        

        <tr style="border-top: 1px solid #cccccc">
            <th scope="row">Enable Label Print</th>
            <td>
            <?php
            echo '<input type="checkbox" name="dvs_label_shipper_enable" value="1" ' . checked( 1, get_option( 'dvs_label_shipper_enable' ), false ) . ' />';?>
            </td>
        </tr>               

        <tr>
            <th scope="row">Shipper Logo Link</th>
            <td>
                <input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_logo" value="<?php echo esc_attr( get_option('dvs_label_shipper_logo') ); ?>" />
                <br><br><small>Note: Upload image in media library and paste link here. Recommended size is 300px width & 100px height</small>
            </td>
        </tr>

        <tr>
        <th scope="row">Select Label Size</th>
        <td>
            <select id="dvs_label_shipper_size" name="dvs_label_shipper_size" required>
                <option value="1" <?php selected($dvs_label_shipper_size,'1'); ?>>A4 - 3 Labels per page</option>
                <option value="5" <?php selected($dvs_label_shipper_size,'5'); ?>>A4 - 4 Labels per page</option>
                <option value="2" <?php selected($dvs_label_shipper_size,'2'); ?>>8x4 inch - 1 Label Per Page</option>
                <option value="3" <?php selected($dvs_label_shipper_size,'3'); ?>>6x3 inch - Thermal Printer</option>
                <option value="4" <?php selected($dvs_label_shipper_size,'4'); ?>>4x6 inch - Thermal Printer</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Select Display Type</th>
        <td>
            <select id="dvs_label_shipper_order_display" name="dvs_label_shipper_order_display" required>
                <option value="barcode" <?php selected($dvs_label_shipper_order_display,'barcode'); ?>>Show order info as barcode</option>
                <option value="qrcode" <?php selected($dvs_label_shipper_order_display,'qrcode'); ?>>Show order info as QR Code</option>
            </select>
            <br><br><small>Note: It will display order information as Barcode or QR code in A4 label template.</small>
        <td>        
        </tr>        

        <tr>
            <th scope="row">Shipper Profile 1</th>
        </tr>

        <tr>  
        <th scope="row">Shipper Name</th>
        <td><input required class="regular-text" placeholder="" type="text" name="dvs_label_shipper_name_1" value="<?php echo esc_attr( get_option('dvs_label_shipper_name_1') ); ?>" /></td>
        </tr>

        <tr>  
        <th scope="row">Shipper Phone</th>
        <td><input required class="regular-text" placeholder="" type="text" name="dvs_label_shipper_phone_1" value="<?php echo esc_attr( get_option('dvs_label_shipper_phone_1') ); ?>" /></td>
        </tr>

        <tr>
        <th scope="row">Shipper City</th>
        <td><input required class="regular-text" placeholder="" type="text" name="dvs_label_shipper_city_1" value="<?php echo esc_attr( get_option('dvs_label_shipper_city_1') ); ?>" /></td>
        </tr> 

        <tr>
        <th scope="row">Shipper Address</th>
        <td><input required class="regular-text" placeholder="" type="text" name="dvs_label_shipper_address_1" value="<?php echo esc_attr( get_option('dvs_label_shipper_address_1') ); ?>" /></td>
        </tr>                           

        <tr>
            <th scope="row">Shipper Profile 2</th>
        </tr>

        <tr>  
        <th scope="row">Shipper Name</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_name_2" value="<?php echo esc_attr( get_option('dvs_label_shipper_name_2') ); ?>" /></td>
        </tr>

        <tr>  
        <th scope="row">Shipper Phone</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_phone_2" value="<?php echo esc_attr( get_option('dvs_label_shipper_phone_2') ); ?>" /></td>
        </tr>

        <tr>
        <th scope="row">Shipper City</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_city_2" value="<?php echo esc_attr( get_option('dvs_label_shipper_city_2') ); ?>" /></td>
        </tr> 

        <tr>
        <th scope="row">Shipper Address</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_address_2" value="<?php echo esc_attr( get_option('dvs_label_shipper_address_2') ); ?>" /></td>
        </tr>

        <tr>
            <th scope="row">Shipper Profile 3</th>
        </tr>

        <tr>  
        <th scope="row">Shipper Name</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_name_3" value="<?php echo esc_attr( get_option('dvs_label_shipper_name_3') ); ?>" /></td>
        </tr>

        <tr>  
        <th scope="row">Shipper Phone</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_phone_3" value="<?php echo esc_attr( get_option('dvs_label_shipper_phone_3') ); ?>" /></td>
        </tr>

        <tr>
        <th scope="row">Shipper City</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_city_3" value="<?php echo esc_attr( get_option('dvs_label_shipper_city_3') ); ?>" /></td>
        </tr> 

        <tr>
        <th scope="row">Shipper Address</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_label_shipper_address_3" value="<?php echo esc_attr( get_option('dvs_label_shipper_address_3') ); ?>" /></td>
        </tr>

    </table>

    <?php   
    submit_button('Submit'); 
    ?>
</form>

<br>
<a href="https://www.youtube.com/watch?v=Ml34che2IDA&t=94s" target="blank" class="woocommerce-Button button">Video: How to setup shipper profiles</a>

<br>
<br>
<a href="https://devsol.pk/contact//" target="blank" class="woocommerce-Button button">Get Support</a>

<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}