<?php

if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_blx_plugin_settings' );
function dvs_blx_plugin_settings() {
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_enable' );	
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_api' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_account' );  
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_username' );    
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_password' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_pickup' );    
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_shipper_city' );    
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_type' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_handling' );        
	register_setting( 'dvs-blx-settings-group', 'dvs_blx_consignee' );       
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_remarks' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_product' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_product_check' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_pieces_check' );     
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_sku_check' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_notes_check' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_weight_check' );
    register_setting( 'dvs-blx-settings-group', 'dvs_blx_cod_check' );                                  
}

//Courier settings input fields
function dvs_blx_api_page() { ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    jQuery(document).ready(function($) {
        $('#dvs_blx_shipper_city').select2();
    });
</script>

<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-blx-settings-group' );
	do_settings_sections( 'dvs-blx-settings-group' ); 
    $dvs_blx_api = get_option('dvs_blx_api');
    $dvs_blx_account = get_option('dvs_blx_account');
    $dvs_blx_username = get_option('dvs_blx_username');
    $dvs_blx_password = get_option('dvs_blx_password');
    $dvs_blx_pickup = get_option('dvs_blx_pickup');    
	$dvs_blx_shipper_city = get_option('dvs_blx_shipper_city');
	$dvs_blx_type = get_option('dvs_blx_type');
	$dvs_blx_handling = get_option('dvs_blx_handling');
	$dvs_blx_consignee = get_option('dvs_blx_consignee');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/blx-label-logo.png'; ?>" height="50px">
    <h2>BlueEx Settings</h2>
    <p>Note: Make sure your BlueEx account API has been activated or contact BlueEx support and ask them to activate your account API. Get your API key from your BlueEx account manager.</p>      
    <table class="form-table">

        <tr>
        <th scope="row">Enable BlueEx API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_blx_enable" value="1" ' . checked( 1, get_option( 'dvs_blx_enable' ), false ) . ' />';?>
        </td>
        </tr>    

        <tr>
        <th scope="row">API Key</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_blx_api" value="<?php echo esc_attr( get_option('dvs_blx_api') ); ?>" /></td>
        </tr>

        <tr>
        <th scope="row">User ID</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_blx_username" value="<?php echo esc_attr( get_option('dvs_blx_username') ); ?>" /></td>
        </tr>

        <tr>
        <th scope="row">Account No</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_blx_account" value="<?php echo esc_attr( get_option('dvs_blx_account') ); ?>" /></td>
        </tr>


        <?php
        if($dvs_blx_api && $dvs_blx_account && $dvs_blx_username) {

            $blx_token = base64_encode($dvs_blx_account . ':' . $dvs_blx_api);

            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://bigazure.com/api/json_v3/services/get_services.php',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 10,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_HTTPHEADER => array(
                'Authorization: Basic '.$blx_token
              ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);

            $service_lists = json_decode($response, true);

            if($service_lists['status'] == 1) {

                $curl = curl_init();
                curl_setopt_array($curl, array(
                  CURLOPT_URL => 'https://bigazure.com/api/json_v3/locations/get_pickup.php',
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 10,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'POST',
                  CURLOPT_POSTFIELDS =>'{"location_id": "all"}',
                  CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Basic '.$blx_token
                  ),
                ));
                $response = curl_exec($curl);
                curl_close($curl);

                $pickup_lists = json_decode($response, true);

                ?>

                <tr>
                <th scope="row">Shipment Type</th>
                <td>
                    <select id="dvs_blx_type" name="dvs_blx_type" >
                    <?php
                    foreach ($service_lists['response']['detail'] as $service_list) { ?>
                        <option value="<?php echo $service_list['service_code'] ?>" <?php selected($dvs_blx_type, $service_list['service_code']); ?>><?php echo $service_list['service_name'] ?></option>
                    <?php } ?>
                <td>        
                </tr>

                <tr>
                <th scope="row">Pickup Address</th>
                <td><select id="dvs_blx_pickup" name="dvs_blx_pickup" >
                    <?php
                    foreach ($pickup_lists['response']['detail'] as $pickup) { ?>
                        <option value="<?php echo $pickup['ID'] ?>" <?php selected($dvs_blx_pickup, $pickup['ID']); ?>><?php echo $pickup['LOCATION'] ?></option>
                    <?php } ?></td>
                </select>
                </tr>

                <tr>
                <th scope="row">Shipper City</th>
                <td><select id="dvs_blx_shipper_city" name="dvs_blx_shipper_city" required >
                    <?php
                    $pickup_url = get_option( 'dvs_url' )."/woo/assets/blx-city.json";
                    $pickup_result = wp_remote_get($pickup_url);
                    $pickup_result = json_decode( wp_remote_retrieve_body( $pickup_result ), true );
                    foreach ($pickup_result['cities'] as $pickup_city) { ?>
                        <option value="<?php echo $pickup_city['city_code'][0] ?>" <?php selected($dvs_blx_shipper_city, $pickup_city['city_code'][0]); ?>><?php echo $pickup_city['city_name'][0] ?></option>
                    <?php } ?></td>
                </select>
                </tr>	        

                <tr>
                <th scope="row">Shipment Handling</th>
                <td>
                    <select id="dvs_blx_handling" name="dvs_blx_handling" required>
                    	<option value="Y" <?php selected($dvs_blx_handling,'Y'); ?>>Fragile</option>
                    	<option value="N" <?php selected($dvs_blx_handling,'N'); ?>>Non Fragile</option>
                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Consginee Details</th>
                <td>
                    <select id="dvs_blx_consignee" name="dvs_blx_consignee" required>
                    <option value="Billing Details" <?php selected($dvs_blx_consignee,'Billing Details'); ?>>Billing Details</option>
                    <option value="Shipping Details" <?php selected($dvs_blx_consignee,'Shipping Details'); ?>>Shipping Details</option>
                    </select>
                <td>        
                </tr>

                <tr>
                <th scope="row">Default Remarks</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_blx_remarks" value="<?php echo esc_attr( get_option('dvs_blx_remarks') ); ?>" required/></td>
                </tr>

                <tr>
                <th scope="row">Default Products</th>
                <td><input class="regular-text" placeholder="" type="text" name="dvs_blx_product" value="<?php echo esc_attr( get_option('dvs_blx_product') ); ?>" /></td>
                </tr>    

                <tr>
                <th scope="row">Print Item Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_blx_product_check" value="1" ' . checked( 1, get_option( 'dvs_blx_product_check' ), false ) . ' />';?>
                </td>
                </tr>

                <tr>
                <th scope="row">Print SKU Name in Label</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_blx_sku_check" value="1" ' . checked( 1, get_option( 'dvs_blx_sku_check' ), false ) . ' />';?>
                </td>
                </tr>       

                <tr>
                <th scope="row">Print Order Notes in Remarks</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_blx_notes_check" value="1" ' . checked( 1, get_option( 'dvs_blx_notes_check' ), false ) . ' />';?>
                </td>
                </tr> 

                <tr>
                <th scope="row">Auto Calculate Weight</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_blx_weight_check" value="1" ' . checked( 1, get_option( 'dvs_blx_weight_check' ), false ) . ' />';?>
                </td>
                </tr>


                <tr>
                <th scope="row">Auto Calculate Pieces</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_blx_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_blx_pieces_check' ), false ) . ' />';?>
                </td>
                </tr>           

                <tr>
                <th scope="row">Calculate Non-COD as Zero</th>
                <td>
                <?php
                echo '<input type="checkbox" name="dvs_blx_cod_check" value="1" ' . checked( 1, get_option( 'dvs_blx_cod_check' ), false ) . ' />';?>
                </td>
                </tr>

            <?php
            }
            else {
                echo '<div class="notice notice-error is-dismissible"><p>Error: Invalid API Key / User ID / Password / Account No</p></div>';
                echo "<br>";
                echo $response;
            }
        }
        ?>               

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<a href="https://www.youtube.com/watch?v=tsbbDRCeaLE" target="blank" class="woocommerce-Button button">Video: How to configure BlueEx Settings</a>
<br>
<br>
<a href="https://devsol.pk/contact/" target="blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}

function dvs_blx_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',
        );
    }
        
    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );

    return $orders_data;
}



function dvs_blx_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'Blue Ex',
        'dvs_slug' => 'blx',
        'dvs_type' => get_option( 'dvs_blx_type' ),
        'dvs_handling' => get_option( 'dvs_blx_handling' ),
        'dvs_consignee' => get_option( 'dvs_blx_consignee' ),
        'dvs_remarks' => get_option( 'dvs_blx_remarks' ),
        'dvs_product' => get_option( 'dvs_blx_product' ),
        'dvs_product_check' => get_option( 'dvs_blx_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_blx_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_blx_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_blx_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_blx_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_blx_cod_check' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'blx_bulk_actions',101 );
function blx_bulk_actions( $bulk_array ) {
    $dvs_blx_enable = get_option( 'dvs_blx_enable' );
    if ($dvs_blx_enable == 1 ) {
        $bulk_array['mark_blx_orders'] = 'BlueEx Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_blx_bulk_action_handler', 9999, 4 );
function dvs_blx_bulk_action_handler( $redirect, $doaction, $object_ids ) {
    if ( $doaction !== 'mark_blx_orders' ) {
        return $redirect;
    }
    $orders_data = [];
    $orders_items = [];
    foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_blx_orders_data($order_id);

    }
    dvs_blx_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'blx_single_order_action', 10, 1 );
function blx_single_order_action( $actions ) {
    $dvs_blx_enable = get_option( 'dvs_blx_enable' );
    if ($dvs_blx_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['blx_action'] = __( 'Book at BlueEx' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_blx_action', 'blx_single_order_booking' );
function blx_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_blx_orders_data($order_id);
    dvs_blx_body_data($orders_data);
    die();
}


add_action( 'init', 'blx_submit_form' );
function blx_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'blx' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "BLX",
                'dvs_blx_api' => get_option('dvs_blx_api'),  
                'dvs_blx_account' => get_option('dvs_blx_account'),           
                'dvs_blx_username'  =>  get_option('dvs_blx_username'),
                'dvs_blx_password'  =>  get_option('dvs_blx_password'),
                'dvs_blx_shipper_city' => get_option('dvs_blx_shipper_city'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  
            $current_order = $order;

            if($response['status'] == 1) {
                $order = new WC_Order($order_id);
                $blx_tracking = $response['cn'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$blx_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at BlueEx with Tracking # ".$blx_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'BlueEx');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $blx_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_courier_link = 'https://www.blue-ex.com/tracking?trackno='.$blx_tracking;
                update_post_meta( $order->get_id(), '_dvs_courier_link', $dvs_courier_link );

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $blx_tracking, 'BlueEx');

                $trackings[] = $blx_tracking;
                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }   

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/blx-label-logo.png'; ?>" height="50px">    
            <h3>BlueEx Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }

            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_blx = get_option( 'dvs_courier_blx' ) + $count ;
        update_option('dvs_courier_blx', $dvs_courier_blx);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'BLX',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}
