<?php


if ( ! defined( 'ABSPATH' ) ) exit;

//register plugin field settings
add_action( 'admin_init', 'dvs_bouraq_plugin_settings' );
function dvs_bouraq_plugin_settings() {
	register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_enable' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_api' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_code' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_city' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_type' );     
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_handling' );           
	register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_consignee' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_products' );	      
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_remarks' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_product_check' );     
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_sku_check' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_notes_check' );
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_weight_check' );    
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_pieces_check' );    
    register_setting( 'dvs-bouraq-settings-group', 'dvs_bouraq_cod_check' );                                
}

//Courier settings input fields
function dvs_bouraq_api_page() { ?>
<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-bouraq-settings-group' );
	do_settings_sections( 'dvs-bouraq-settings-group' );
    $dvs_bouraq_city = get_option('dvs_bouraq_city');
	$dvs_bouraq_type = get_option('dvs_bouraq_type');
	$dvs_bouraq_handling = get_option('dvs_bouraq_handling');
	$dvs_bouraq_consignee = get_option('dvs_bouraq_consignee');
 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/bouraq-label-logo.png'; ?>" height="50px">
    <h2>Bouraq Express Settings</h2>
    <table class="form-table">

        <tr>
        <th scope="row">Enable Bouraq Express API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_bouraq_enable" value="1" ' . checked( 1, get_option( 'dvs_bouraq_enable' ), false ) . ' />';?>
        </td>
        </tr> 

        <tr>
        <th scope="row">API Key</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_bouraq_api" value="<?php echo esc_attr( get_option('dvs_bouraq_api') ); ?>" required /></td>
        </tr>  

        <tr>
        <th scope="row">Client Code</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_bouraq_code" value="<?php echo esc_attr( get_option('dvs_bouraq_code') ); ?>" required /></td>
        </tr> 

        <tr>
        <th scope="row">Shipper City</th>
        <td>
            <select id="dvs_bouraq_city" name="dvs_bouraq_city" required >
                <option value="Lahore" <?php selected($dvs_bouraq_city,'Lahore'); ?>>Lahore</option>
                <option value="Karachi" <?php selected($dvs_bouraq_city,'Karachi'); ?>>Karachi</option>
                <option value="Islamabad" <?php selected($dvs_bouraq_city,'Islamabad'); ?>>Islamabad</option>
                <option value="Rawalpindi" <?php selected($dvs_bouraq_city,'Rawalpindi'); ?>>Rawalpindi</option>
                <option value="Multan" <?php selected($dvs_bouraq_city,'Multan'); ?>>Multan</option>
                <option value="Gujranwala" <?php selected($dvs_bouraq_city,'Gujranwala'); ?>>Gujranwala</option>
                <option value="Sailkot" <?php selected($dvs_bouraq_city,'Sailkot'); ?>>Sailkot</option>
                <option value="Faisalabad" <?php selected($dvs_bouraq_city,'Faisalabad'); ?>>Faisalabad</option>
                <option value="Sargodha" <?php selected($dvs_bouraq_city,'Sargodha'); ?>>Sargodha</option>
                <option value="Peshawar" <?php selected($dvs_bouraq_city,'Peshawar'); ?>>Peshawar</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Shipment Type</th>
        <td>
            <select id="dvs_bouraq_type" name="dvs_bouraq_type" required >
            	<option value="Cash On Delivery" <?php selected($dvs_bouraq_type,'Cash On Delivery'); ?>>Cash On Delivery</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Shipment Handling</th>
        <td>
            <select id="dvs_bouraq_handling" name="dvs_bouraq_handling" required >
            	<option value="Yes" <?php selected($dvs_bouraq_handling,'Yes'); ?>>Fragile</option>
            </select>
        <td>        
        </tr>        

        <tr>
        <th scope="row">Consginee Details</th>
        <td>
            <select id="dvs_bouraq_consignee" name="dvs_bouraq_consignee" required >
            <option value="Billing Details" <?php selected($dvs_bouraq_consignee,'Billing Details'); ?>>Billing Details</option>
            <option value="Shipping Details" <?php selected($dvs_bouraq_consignee,'Shipping Details'); ?>>Shipping Details</option>
            </select>
        <td>        
        </tr>

        <tr>
        <th scope="row">Default Remarks</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_bouraq_remarks" value="<?php echo esc_attr( get_option('dvs_bouraq_remarks') ); ?>" required /></td>
        </tr>  

        <tr>
        <th scope="row">Default Products</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_bouraq_products" value="<?php echo esc_attr( get_option('dvs_bouraq_products') ); ?>" /></td>
        </tr>  

        <tr>
        <th scope="row">Print Item Name in Label</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_bouraq_product_check" value="1" ' . checked( 1, get_option( 'dvs_bouraq_product_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Print SKU Name in Label</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_bouraq_sku_check" value="1" ' . checked( 1, get_option( 'dvs_bouraq_sku_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Print Order Notes in Remarks</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_bouraq_notes_check" value="1" ' . checked( 1, get_option( 'dvs_bouraq_notes_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Auto Calculate Weight</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_bouraq_weight_check" value="1" ' . checked( 1, get_option( 'dvs_bouraq_weight_check' ), false ) . ' />';?>
        </td>
        </tr>               

        <tr>
        <th scope="row">Auto Calculate Pieces</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_bouraq_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_bouraq_pieces_check' ), false ) . ' />';?>
        </td>
        </tr>

        <tr>
        <th scope="row">Calculate Non-COD as Zero</th>
        <td>
        <?php
        echo '<input type="checkbox" name="dvs_bouraq_cod_check" value="1" ' . checked( 1, get_option( 'dvs_bouraq_cod_check' ), false ) . ' />';?>
        </td>
        </tr>                        

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>

<br>
<a href="https://www.loom.com/share/1b437de929a341b6b667fc91cb93b3d6" target="blank" class="woocommerce-Button button">Video: How to configure Bouraq Express Settings</a>
<br>
<br>
<a href="https://devsol.pk/contact/" target="blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}

function dvs_bouraq_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',
        );
    }
        
    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );
    
    return $orders_data;
}



function dvs_bouraq_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'Bouraq Express',
        'dvs_slug' => 'bouraq',
        'dvs_type' => get_option( 'dvs_bouraq_type' ),
        'dvs_handling' => get_option( 'dvs_bouraq_handling' ),
        'dvs_consignee' => get_option( 'dvs_bouraq_consignee' ),
        'dvs_remarks' => get_option( 'dvs_bouraq_remarks' ),
        'dvs_product' => get_option( 'dvs_bouraq_product' ),
        'dvs_product_check' => get_option( 'dvs_bouraq_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_bouraq_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_bouraq_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_bouraq_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_bouraq_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_bouraq_cod_check' ),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'bouraq_bulk_actions',101 );
function bouraq_bulk_actions( $bulk_array ) {
    $dvs_bouraq_enable = get_option( 'dvs_bouraq_enable' );
    if ($dvs_bouraq_enable == 1 ) {
        $bulk_array['mark_bouraq_orders'] = 'Bouraq Express Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_bouraq_bulk_action_handler', 9999, 4 );
function dvs_bouraq_bulk_action_handler( $redirect, $doaction, $object_ids ) {
	if ( $doaction !== 'mark_bouraq_orders' ) {
	    return $redirect;
	}
    $orders_data = [];
    $orders_items = [];
	foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_bouraq_orders_data($order_id);

    }
    dvs_bouraq_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'bouraq_single_order_action', 10, 1 );
function bouraq_single_order_action( $actions ) {
    $dvs_bouraq_enable = get_option( 'dvs_bouraq_enable' );
    if ($dvs_bouraq_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['bouraq_action'] = __( 'Book at Bouraq Express' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_bouraq_action', 'bouraq_single_order_booking' );
function bouraq_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_bouraq_orders_data($order_id);
    dvs_bouraq_body_data($orders_data);
    die();
}


add_action( 'init', 'bouraq_submit_form' );
function bouraq_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'bouraq' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "BOURAQ",
				'dvs_bouraq_api' => get_option('dvs_bouraq_api'),
                'dvs_bouraq_code' => get_option('dvs_bouraq_code'),
                'dvs_bouraq_city' => get_option('dvs_bouraq_city'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  
            $current_order = $order;

            if (!empty($response['tracking_no'])) {
                $order = new WC_Order($order_id);
                $bouraq_tracking =  $response['tracking_no'];
                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$bouraq_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at Bouraq Express with Tracking # ".$bouraq_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'Bouraq Express');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $bouraq_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_courier_link = 'https://bouraqcod.com/portal/track-details.php?track_code='.$bouraq_tracking;
                update_post_meta( $order->get_id(), '_dvs_courier_link', $dvs_courier_link ); 

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $bouraq_tracking, 'Bouraq Express');
                $trackings[] = $bouraq_tracking;
                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }    

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/bouraq-label-logo.png'; ?>" height="50px">    
            <h3>Bouraq Express Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }

            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_bouraq = get_option( 'dvs_courier_bouraq' ) + $count ;
        update_option('dvs_courier_bouraq', $dvs_courier_bouraq);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'bouraq',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}


