<?php

require_once plugin_dir_path( __DIR__ ).'/vendor/autoload.php';

$barcode_generator = new Picqer\Barcode\BarcodeGeneratorPNG();

$profile = $_POST['hxs_shipper_profile'] ?? '1';

$label_name = get_option('dvs_label_shipper_name_' . $profile);	
$label_phone = get_option('dvs_label_shipper_phone_' . $profile);	
$label_address = get_option('dvs_label_shipper_address_' . $profile);	
$label_city = get_option('dvs_label_shipper_city_' . $profile);	
$label_logo = get_option('dvs_label_shipper_logo');

?>

<html>
<head>
	<meta charset="utf-8">
	<title>Single Label Per Page</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Condensed:wght@400;700&display=swap" rel="stylesheet">

	<style>
	    /*! normalize.css v7.0.0 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}body{margin:0}article,aside,footer,header,nav,section{display:block}h1{font-size:2em;margin:.67em 0}figcaption,figure,main{display:block}figure{margin:1em 40px}hr{box-sizing:content-box;height:0;overflow:visible}pre{font-family:monospace,monospace;font-size:1em}a{background-color:transparent;-webkit-text-decoration-skip:objects}abbr[title]{border-bottom:none;text-decoration:underline;text-decoration:underline dotted}b,strong{font-weight:inherit}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace,monospace;font-size:1em}dfn{font-style:italic}mark{background-color:#ff0;color:#000}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}audio,video{display:inline-block}audio:not([controls]){display:none;height:0}img{border-style:none}svg:not(:root){overflow:hidden}button,input,optgroup,select,textarea{font-family:sans-serif;font-size:100%;line-height:1.15;margin:0}button,input{overflow:visible}button,select{text-transform:none}[type=reset],[type=submit],button,html [type=button]{-webkit-appearance:button}[type=button]::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner,button::-moz-focus-inner{border-style:none;padding:0}[type=button]:-moz-focusring,[type=reset]:-moz-focusring,[type=submit]:-moz-focusring,button:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:.35em .75em .625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}progress{display:inline-block;vertical-align:baseline}textarea{overflow:auto}[type=checkbox],[type=radio]{box-sizing:border-box;padding:0}[type=number]::-webkit-inner-spin-button,[type=number]::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}[type=search]::-webkit-search-cancel-button,[type=search]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}details,menu{display:block}summary{display:list-item}canvas{display:inline-block}template{display:none}[hidden]{display:none}/*# sourceMappingURL=normalize.min.css.map */
		@page { margin: 0 }
		body { margin: 0 }
		.sheet {
		  margin: 0;
		  overflow: hidden;
		  position: relative;
		  box-sizing: border-box;
		  page-break-after: always;
		}

		/** Paper sizes **/
		body.A3               .sheet { width: 297mm; height: 419mm }
		body.A3.landscape     .sheet { width: 420mm; height: 296mm }
		body.A4               .sheet { width: 210mm; height: 296mm }
		body.A4.landscape     .sheet { width: 297mm; height: 209mm }
		body.A5               .sheet { width: 148mm; height: 209mm }
		body.A5.landscape     .sheet { width: 210mm; height: 147mm }
		body.letter           .sheet { width: 216mm; height: 279mm }
		body.letter.landscape .sheet { width: 280mm; height: 215mm }
		body.legal            .sheet { width: 216mm; height: 356mm }
		body.legal.landscape  .sheet { width: 357mm; height: 215mm }
		body.single  		  .sheet { width: 200mm; height: 100mm }

		/** Padding area **/
		.sheet.padding-5mm  { padding: 5mm }
		.sheet.padding-10mm { padding: 10mm }
		.sheet.padding-15mm { padding: 15mm }
		.sheet.padding-20mm { padding: 20mm }
		.sheet.padding-25mm { padding: 25mm }

		/** For screen preview **/
		@media screen {
		  body { background: #e0e0e0 }
		  .sheet {
		    background: white;
		    box-shadow: 0 .5mm 2mm rgba(0,0,0,.3);
		    margin: 5mm auto;
		  }
		}

		/** Fix for Chrome issue #273306 **/
		@media print {
		           body.A3.landscape { width: 420mm }
		  body.A3, body.A4.landscape { width: 297mm }
		  body.A4, body.A5.landscape { width: 210mm }
		  body.A5                    { width: 148mm }
		  body.letter, body.legal    { width: 216mm }
		  body.letter.landscape      { width: 280mm }
		  body.legal.landscape       { width: 357mm }
		  body.single       		 { width: 200mm }
		}

		/* @page { 
			size: A5;
		} */

		body {
			font-family: 'Roboto Condensed', sans-serif;
            font-weight: normal;
			font-size: 12px;
		}

        strong {
            font-weight: bold;
        }

		.label-box {
			width: 100%;
			float: left;
			margin-bottom: 0.25in;
		}

		.container {
			width: 7.5in;
			height: 3in;
			float: left;
			margin: 0px;
			margin-bottom: .5in;
		}

		.col-100 {
			width: 100%;
			float: left;
		}

		.col-75 {
			width: 75%;
			float: left;
		}

		.col-50 {
			width: 50%;
			float: left;
		}

		.col-25 {
			width: 25%;
			float: left;
		}

		.col-33 {
			width: 33.33%;
			float: left;
		}

		.col-16 {
			width: 16.66%;
			float: left;
		}

		.border-box {
			height: 100%;
			border: 1px solid #000000;
		}

		.border-lr {
			border-left: 1px solid #000000;
			border-right: 1px solid #000000;
		}

		.border {
			border: 1px solid #000000;
		}

		.border-top {
			border-top: 1px solid #cccccc;
		}

		.border-bottom {
			border-bottom: 1px solid #cccccc;
		}

		.border-dotted {
			font-size: 16px;
			border: 1px dotted #000000;
		}

		.center {
			text-align: center;
		}

		.height-logo {
			height: 100px;
		}

		.height-address {
			height: 50px;
		}

		.height-100 {
			height: 100%;
		}

		.height-300 {
			height: 2in;
		}

		.height-50 {
			height: 50px;
		}

		.height-75 {
			height: 75px;
		}		

		.height-50 {
			height: 50px;
			line-height: 15px;
		}

		.height-30 {
			height: 30px;
			line-height: 15px;
		}

		.inch-half {
			height: .5in;
		}

		.inch-075 {
			height: .75in;
		}        

		.inch-2 {
			height: 2.15in;
		}		

		.justify {
			justify-content: center;
		    align-items: center;
		    display: flex;			
		}

		.logo {
			width: 75px;
			height: 75px;
		}


		.mtb-10 {
			margin: 0px 10px;
		}

		.ptb-10 {
			padding: 10px 0px;
		}

		.ptb-5 {
			padding: 5px 0px;
		}

		.pb-2 {
			padding-bottom: 2px;
		}        

		.ptblr-10 {
			padding: 10px;
		}

		.ptblr-5 {
			padding: 5px;
		}

		.ptblr-3 {
			padding: 3px;
		}		

		.font-10 {
			font-size: 10px;
		}

		.font-12 {
			font-size: 12px;
		}

		.font-13 {
			font-size: 13px;
		}

		.font-14 {
			font-size: 14px;
		}		

		.font-15 {
			font-size: 15px;
		}

		.font-16 {
			font-size: 16px;
		}        

		.font-20 {
			font-size: 20px;
		}				

		.center {
			text-align: center;
		}

		.border-1 {
			border-top: none;
	    	border-left: none;
	    	border-right: none;			
		}

		.border-2 {
			border-top: none;
	    	border-bottom: none;
	    	border-right: none;			
		}

		.border-3 {
			border-top: none;
			border-bottom: none;
		}

		.float-right {
			float: right;
		}

		.parcel-margin {
			margin-bottom: 0.5in;
		}


		@page {
		    size: A4;
		    margin: 0;
		}

		.sheet {
		    page-break-after: always; /* Ensures proper page breaks */
		}

		.sheet:last-of-type {
		    page-break-after: avoid !important; /* Prevents blank last page */
		}

		
	</style>
</head>

<body onload = "window.print()" class="single">
	
	<?php 
	$page_index = 1;
	foreach($parcels as $index => $parcel):
		if($page_index === 1){
			echo '<section class="sheet padding-5mm">';
		}
		$key = get_courier_key($parcel->courier_name);
	?>

	<div class="label-box">
		<div class="container" >

			<div class="col-100">
				<div class="col-33 inch-2">
					<div class="border-box" style="border-right: none;">
						<div class="border justify ptb-5 border-1">
							<strong>Consignee Information</strong>
						</div>
						<div class="ptblr-5" style="line-height:15px">
							<strong>Name: </strong>
							<span><?= $parcel->consignee_name ?></span>
							<br>
							<strong>Phone: </strong>
							<span><?= $parcel->consignee_phone ?></span>
							<br>
							<strong>Address: </strong>
							<span style="line-height: 15px;"><?= $parcel->consignee_address ?></span>		
						</div>
						<div class="col-100 border-top">
							<div class="ptblr-5 font-14">
								<strong>Destination: </strong> 
								<span><?= $parcel->courier_destination ?></span>		
							</div>						
						</div>
                        <div class="col-100 border-top">
							<div class="ptblr-5 font-14">
                                <strong>Order #: </strong>
                                <span><?= $parcel->order_name ?></span>
                             	<?php
                                	if($key == 'ahl') {
                                		$courier_tracking = '#' .$parcel->courier_tracking;
                                	}
                                	else {
                                		$courier_tracking = $parcel->courier_tracking;
                                	}
                                ?>
                                <img style="width:45px;float:right" src='https://image-charts.com/chart?chof=.svg&cht=qr&chl=<?= $parcel->courier_name.','.urlencode($courier_tracking).','.$parcel->order_name.','.(int)$parcel->order_amount ?>&chs=100x100&choe=UTF-8'>
                            </div>
                        </div>                         
					</div>	
				</div>

				<div class="col-33 inch-2">
					<div class="border-box" style="border-right: none;">
						<div class="border justify ptb-5 border-1">
							<strong>Shipper Information</strong>
						</div>

						<div class="col-100">
							<div class="col-100">
								<div class="ptblr-5 justify border-bottom">
									<?php if(!empty($label_logo)) { ?>
										<img src="<?= $label_logo ?>" height="45px">
									<?php } ?>
								</div>
							</div>							
						</div>
						<div class="col-100">
							<div class="border-bottom ptblr-5 font-12" style="line-height: 15px;">
								<strong>Shipper: </strong>
								<span><?= $label_name ?></span>
								<span style="float:right"><?= $label_phone ?></span>
								<br>
								<strong>Shipper Address: </strong>
								<span style="line-height: 15px;"><?= $label_address ?></span>	
								<br>	
							</div>	
						</div>
                        <div class="col-100 justify">
							<div class="ptblr-5 font-20">
                                <strong>COD: </strong>
                                <span>Rs <?= (int)$parcel->order_amount ?></span>
                            </div>
                        </div>
                        <div class="col-100 justify">
                        	<?php
								echo '<img alt="order-barcode" src="data:image/png;base64,' . base64_encode($barcode_generator->getBarcode((int)$parcel->order_amount, $barcode_generator::TYPE_CODE_128)) . '" height="20px">';
                        	?>
						</div>                       					
					</div>	
				</div>

				<div class="col-33 inch-2">
					<div class="border-box">
						<div class="border justify ptb-5 border-1">
							<strong>Parcel Information</strong>
						</div>
                        <div class="col-100">
                            <div class="border-bottom ptblr-5">
                            	<?php
    	    						$courier_logo = plugin_dir_url( __DIR__ ) . "images/{$key}-label-logo.png";
                            	?>                          	
                                <img src="<?= $courier_logo ?>" height="45px">
                                <img class="float-right" src='https://image-charts.com/chart?chof=.svg&cht=qr&chl=<?= urlencode($courier_tracking) ?>&chs=50x50&choe=UTF-8' alt='' height='50px'>                                  
                            </div>
						</div>                         
						<div class="col-100 border-bottom ptb-5">
                            <center>
	                        	<?php
									echo '<img class="pb-2" alt="courier-barcode" src="data:image/png;base64,' . base64_encode($barcode_generator->getBarcode($courier_tracking, $barcode_generator::TYPE_CODE_128)) . '" height="18px">';
	                        	?>
                            </center>
                            <div class="font-14 justify"><span><?= $courier_tracking ?></span></div>
                        </div>
                        <div class="col-100">
                            <div class="border-bottom ptblr-5">
                                <strong>Service: </strong> 
                                <span><?php echo !empty(trim($parcel->courier_service)) && $parcel->courier_service != '-' ? $parcel->courier_service : $parcel->courier_type ?></span>
                                <?php
                                	if($key == "trax") {
                                		$trax_open = get_option('dvs_trax_box');
                                		if($trax_open == 1) {
                                			$trax_open_text = "Yes";
                                		}
                                		else {
                                			$trax_open_text = "No";
                                		}
                                		?>
                                		<div style="float: right;">
                                			<strong>Allow Open: </strong>
                                			<span><?= $trax_open_text ?></span>
                                		</div>
                                		<?php
                                	}
                                ?>                                
                            </div>                                 
                            <div class="border-bottom ptblr-5">
                                <strong>Date: </strong>
                                <span><?= substr($parcel->courier_datetime, 0, 10) ?></span>
                                <div style="float: right">
                                    <strong>Weight: </strong>
                                    <?php if($key == 'lcs') { ?>
                                        <span><?= $parcel->order_weight ?> (Grams)</span>
                                    <?php }
                                    else { ?>
                                        <span><?= $parcel->order_weight ?> KG</span>
                                    <?php }?>
                                </div>    
                            </div>
                            <div class="ptblr-5">
                                <strong>Fragile: </strong>
                                <span><?= $parcel->courier_handling ?></span>
                                <div style="float: right">
                                    <strong>Pieces: </strong> 
                                    <span><?= $parcel->order_pieces ?></span>
                                </div>    
                            </div>
                        </div>                                              			
					</div>
				</div>

			</div>

			<div class="col-100">
                <div class="ptblr-5" style="border-right: 1px solid #000000; border-left: 1px solid #000000">
                    <strong>Remarks: </strong><span><?= $parcel->order_remarks ?></span>
                </div>
			</div>

			<div class="col-100" style="line-height: 15px;">
                <div class="inch-075 ptblr-5" style="border: 1px solid #000000">
                    <strong>Products: </strong><span class="consignee-products"><?= $parcel->order_products ?></span>
                </div>
			</div>
		</div>
	</div>	
	<?php
	++$page_index;
	if($page_index === 2 || $index === count($parcels) - 1 ){
		$page_index = 1;
		echo "</section>";
	}
	endforeach;
	?>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

	<script>
	$(document).ready(function(){
	  $('.consignee-products').each(function (f) {
	      var newstr = $(this).text().substring(0,700);
	      $(this).text(newstr);

	    });
	})
	</script>

</body>