<?php

if ( ! defined( 'ABSPATH' ) ) exit;

// Register plugin field settings
add_action( 'admin_init', 'dvs_tcs_plugin_settings' );
function dvs_tcs_plugin_settings() {
    $fields = [
        'dvs_tcs_enable',
        'dvs_tcs_username',
        'dvs_tcs_password',
        'dvs_tcs_account',
        'dvs_tcs_auth',
        'dvs_tcs_token',
        'dvs_tcs_location',
        'dvs_tcs_insurance',
        'dvs_tcs_type',
        'dvs_tcs_handling',
        'dvs_tcs_consignee',
        'dvs_tcs_remarks',
        'dvs_tcs_product',
        'dvs_tcs_product_check',
        'dvs_tcs_pieces_check',
        'dvs_tcs_sku_check',
        'dvs_tcs_notes_check',
        'dvs_tcs_weight_check',
        'dvs_tcs_cod_check',
    ];

    foreach ( $fields as $field ) {
        register_setting( 'dvs-tcs-settings-group', $field );
    }
}

// Preserve trailing spaces in dvs_tcs_username
add_filter( 'sanitize_option_dvs_tcs_username', function ( $value ) {
    // Return the raw, unsanitized value to preserve spaces
    return isset( $_POST['dvs_tcs_username'] ) ? wp_unslash( $_POST['dvs_tcs_username'] ) : $value;
});


//Courier settings input fields
function dvs_tcs_api_page() { ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    jQuery(document).ready(function($) {
        $('#dvs_tcs_city').select2();
    });
</script>
    
<div class="wrap">
<form method="post" action="options.php">
    <?php 
	settings_fields( 'dvs-tcs-settings-group' );
	do_settings_sections( 'dvs-tcs-settings-group' );

	$dvs_tcs_type = get_option('dvs_tcs_type');
	$dvs_tcs_handling = get_option('dvs_tcs_handling');
	$dvs_tcs_consignee = get_option('dvs_tcs_consignee');

    $dvs_tcs_location = get_option('dvs_tcs_location');

 	?>
    <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/tcs-label-logo.png'; ?>" height="50px">
    <h2>TCS Settings</h2>
    <p>Note: Use the same username and password that you use for logging into the <a href="https://envio.tcscourier.com/UserAccount/Login" target="blank">TCS Envio Portal</a></p>

    <table class="form-table">

        <tr>
        <th scope="row">Enable TCS API</th>
        <td>
	    <?php
	    echo '<input type="checkbox" name="dvs_tcs_enable" value="1" ' . checked( 1, get_option( 'dvs_tcs_enable' ), false ) . ' />';?>
        </td>
        </tr>               

        <tr>
            <th scope="row">Username</th>
            <td>
                <input class="regular-text" placeholder="" type="text" name="dvs_tcs_username"
                       value="<?php echo esc_attr(get_option('dvs_tcs_username')); ?>" required />
            </td>
        </tr>

        <tr>
        <th scope="row">Password</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_tcs_password" value="<?php echo esc_attr( get_option('dvs_tcs_password') ); ?>" required /></td>
        </tr>


        <tr>
        <th scope="row">Account Number</th>
        <td><input class="regular-text" placeholder="" type="text" name="dvs_tcs_account" value="<?php echo esc_attr( get_option('dvs_tcs_account') ); ?>" required /></td>
        </tr>

        <?php

        $dvs_tcs_username = get_option('dvs_tcs_username');
        $dvs_tcs_password = get_option('dvs_tcs_password');
        $dvs_tcs_account = get_option('dvs_tcs_account');

        if($dvs_tcs_username && $dvs_tcs_password && $dvs_tcs_account) {
        
            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://ucp-woo.devsol.org/woo/tcs.php',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Token: A8xZ3NqLB5tY1WkVQ9fLmR2CX7ePdT4G'
              ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            $result = json_decode($response, true);

            $dvs_tcs_auth = $result['authorization'];

            $curl = curl_init();
            curl_setopt_array($curl, array(
              CURLOPT_URL => 'https://connect.tcscourier.com/ecom/api/authentication/token?username='.urlencode($dvs_tcs_username).'&password='.urlencode($dvs_tcs_password),
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 30,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'GET',
              CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer '.$dvs_tcs_auth
              ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);

            $result = json_decode($response, true);
            
            if (isset($result['accesstoken'])) {

                $dvs_tcs_token = $result['accesstoken'];

                $curl = curl_init();
                curl_setopt_array($curl, array(
                  CURLOPT_URL => 'https://connect.tcscourier.com/ecom/api/inquiry/costcenterinquiry?accesstoken='.urlencode($dvs_tcs_token).'&customerno='.$dvs_tcs_account,
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 30,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'GET',
                  CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Authorization: Bearer '.$dvs_tcs_auth
                  ),
                ));
                $response = curl_exec($curl);
                curl_close($curl);

                $result = json_decode($response, true);

                $cost_centers = $result['detail'] ?? [];
                if (is_array($cost_centers) && isset($cost_centers[0]['costcentercode'])) {
                    ?>

                    <input class="regular-text" placeholder="" type="hidden" name="dvs_tcs_auth" value="<?= $dvs_tcs_auth ?>" required />                

                    <input class="regular-text" placeholder="" type="hidden" name="dvs_tcs_token" value="<?= $dvs_tcs_token ?>" required />
                    
                    <tr>
                    <th scope="row">Cost Center</th>
                    <td>
                        <select id="dvs_tcs_location" name="dvs_tcs_location" required>
                            <?php
                            foreach ($cost_centers as $cost_center) {
                                $cost_center_json = json_encode($cost_center);
                                $cost_center_detail = $cost_center['costcentercode'] . ' - ' . $cost_center['pickupaddress'];
                            ?>
                                <option value="<?= esc_attr($cost_center_json) ?>" <?php selected($dvs_tcs_location, $cost_center_json); ?>><?= esc_html($cost_center_detail) ?></option>
                            <?php } ?>
                        </select>
                    </td>
                    </tr>


                    <tr>
                    <th scope="row">Default Insurance</th>
                    <td><input class="regular-text" placeholder="" type="text" name="dvs_tcs_insurance" value="<?php echo esc_attr( get_option('dvs_tcs_insurance') ); ?>" required /></td>
                    </tr>        	        
             
                    <tr>
                    <th scope="row">Shipment Type</th>
                    <td>
                        <select id="dvs_tcs_type" name="dvs_tcs_type" required>
                        	<option value="O" <?php selected($dvs_tcs_type,'O'); ?>>Express</option>
                        	<option value="D" <?php selected($dvs_tcs_type,'D'); ?>>Economy Express</option>
                        	<option value="S" <?php selected($dvs_tcs_type,'S'); ?>>Same Day</option>
                        	<option value="OLE" <?php selected($dvs_tcs_type,'OLE'); ?>>Overland</option>
                        	<option value="MYO" <?php selected($dvs_tcs_type,'MYO'); ?>>My Collect</option>
                        </select>
                    <td>        
                    </tr>

                    <tr>
                    <th scope="row">Shipment Handling</th>
                    <td>
                        <select id="dvs_tcs_handling" name="dvs_tcs_handling" required>
                        	<option value="true" <?php selected($dvs_tcs_handling,'true'); ?>>Fragile</option>
                        	<option value="false" <?php selected($dvs_tcs_handling,'false'); ?>>Non Fragile</option>
                        </select>
                    <td>        
                    </tr>        

                    <tr>
                    <th scope="row">Consginee Details</th>
                    <td>
                        <select id="dvs_tcs_consignee" name="dvs_tcs_consignee" required>
                        <option value="Billing Details" <?php selected($dvs_tcs_consignee,'Billing Details'); ?>>Billing Details</option>
                        <option value="Shipping Details" <?php selected($dvs_tcs_consignee,'Shipping Details'); ?>>Shipping Details</option>
                        </select>
                    <td>        
                    </tr>

                    <tr>
                    <th scope="row">Default Remarks</th>
                    <td><input class="regular-text" placeholder="" type="text" name="dvs_tcs_remarks" value="<?php echo esc_attr( get_option('dvs_tcs_remarks') ); ?>" required/></td>
                    </tr>

                    <tr>
                    <th scope="row">Default Product</th>
                    <td><input class="regular-text" placeholder="" type="text" name="dvs_tcs_product" value="<?php echo esc_attr( get_option('dvs_tcs_product') ); ?>" /></td>
                    </tr>    

                    <tr>
                    <th scope="row">Print Item Name in Label</th>
                    <td>
                    <?php
                    echo '<input type="checkbox" name="dvs_tcs_product_check" value="1" ' . checked( 1, get_option( 'dvs_tcs_product_check' ), false ) . ' />';?>
                    </td>
                    </tr>

                    <tr>
                    <th scope="row">Print SKU Name in Label</th>
                    <td>
                    <?php
                    echo '<input type="checkbox" name="dvs_tcs_sku_check" value="1" ' . checked( 1, get_option( 'dvs_tcs_sku_check' ), false ) . ' />';?>
                    </td>
                    </tr>

                    <tr>
                    <th scope="row">Print Order Notes in Remarks</th>
                    <td>
                    <?php
                    echo '<input type="checkbox" name="dvs_tcs_notes_check" value="1" ' . checked( 1, get_option( 'dvs_tcs_notes_check' ), false ) . ' />';?>
                    </td>
                    </tr>        

                    <tr>
                    <th scope="row">Auto Calculate Weight</th>
                    <td>
                    <?php
                    echo '<input type="checkbox" name="dvs_tcs_weight_check" value="1" ' . checked( 1, get_option( 'dvs_tcs_weight_check' ), false ) . ' />';?>
                    </td>
                    </tr>

                    <tr>
                    <th scope="row">Auto Calculate Pieces</th>
                    <td>
                    <?php
                    echo '<input type="checkbox" name="dvs_tcs_pieces_check" value="1" ' . checked( 1, get_option( 'dvs_tcs_pieces_check' ), false ) . ' />';?>
                    </td>
                    </tr>           

                    <tr>
                    <th scope="row">Calculate Non-COD as Zero</th>
                    <td>
                    <?php
                    echo '<input type="checkbox" name="dvs_tcs_cod_check" value="1" ' . checked( 1, get_option( 'dvs_tcs_cod_check' ), false ) . ' />';?>
                    </td>
                    </tr>   
                <?php
                }
                else {
                    echo '<div class="notice notice-error is-dismissible"><p>Error: Cost center not existed. Please create cost center in TCS Envio portal and check the guide</p><hr><span style="font-family: monospace;">'.$response. '</span></div>';                    
                }
            }
            else {
                echo '<div class="notice notice-error is-dismissible"><p>Error: Invalid TCS Username / Password or Account Number. Please check the guide</p><hr><span style="font-family: monospace;">'.$response. '</span></div>';
            }
        }
        ?>                         

    </table>

    <?php 	
	submit_button('Submit'); 
	?>
</form>


<br>
<a href="https://www.youtube.com/watch?v=CjyZneLEEbM" target="_blank" class="woocommerce-Button button">Video: How to configure TCS Settings</a>
<br>
<br>
<a href="https://devsol.pk/contact/" target="_blank" class="woocommerce-Button button">Get Support</a>
<br>
<br>
<a href="https://wa.me/9203234152099" target="_blank" class="woocommerce-Button button">WhatsApp Support</a>

</div>

<?php 
}




function dvs_tcs_orders_data($order_id) {

    $order = wc_get_order($order_id);

    foreach ($order->get_items() as $item_key => $item ) {
        $order_product = $item->get_product();
        $orders_items[] = array(
            'item_name' => $item['name'],
            'item_qty' => $item['qty'],
            'item_sku'    => $order_product ? $order_product->get_sku() : '',
            'item_weight' => $order_product ? $order_product->get_weight() : '',
            'item_status' => $order_product ? $order_product->get_status() : '',

        );
    }

    $orders_data = array(
        'status' => $order->get_meta('_dvs_courier_check'),
        'order_id' => $order->get_id(),
        'order_number' => $order->get_order_number(),
        'gateway' => $order->get_payment_method(),
        'amount' => $order->get_total(),
        'email' => $order->get_billing_email(),
        'notes' => $order->get_customer_note(),
        'billing_name' => $order->get_billing_first_name() . ' ' . $order->get_billing_last_name(),
        'billing_address' => $order->get_billing_address_1() . ' ' . $order->get_billing_address_2(),
        'billing_city' => $order->get_billing_city(),
        'billing_phone' => $order->get_billing_phone(),
        'shipping_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
        'shipping_address' => $order->get_shipping_address_1() . ' ' . $order->get_shipping_address_2(),
        'shipping_city' => $order->get_shipping_city(),
        'shipping_phone' => get_post_meta($order->get_id(), '_shipping_phone', true),
        'orders_items' => $orders_items,
    );
    
    return $orders_data;
}



function dvs_tcs_body_data($orders_data) {
    $response = [
        'orders' => $orders_data,
        'dvs_courier' => 'TCS',
        'dvs_slug' => 'tcs',
        'dvs_type' => get_option( 'dvs_tcs_type' ),
        'dvs_handling' => get_option( 'dvs_tcs_handling' ),
        'dvs_consignee' => get_option( 'dvs_tcs_consignee' ),
        'dvs_remarks' => get_option( 'dvs_tcs_remarks' ),
        'dvs_product' => get_option( 'dvs_tcs_product' ),
        'dvs_product_check' => get_option( 'dvs_tcs_product_check' ),
        'dvs_sku_check' => get_option( 'dvs_tcs_sku_check' ),
        'dvs_notes_check' => get_option( 'dvs_tcs_notes_check' ),
        'dvs_weight_check' => get_option( 'dvs_tcs_weight_check' ), 
        'dvs_pieces_check' => get_option( 'dvs_tcs_pieces_check' ),
        'dvs_cod_check' => get_option( 'dvs_tcs_cod_check' ),
        'dvs_tcs_insurance' => get_option( 'dvs_tcs_insurance' ),
        'dvs_tcs_location' => json_decode(get_option('dvs_tcs_location')),
    ];
    $body = json_encode($response, true);
    $url = get_option( 'dvs_url' ).'/woo/form.php';
    $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $body));
    if (is_wp_error($output)) {
        $error = $output->get_error_message();
        echo "Error: $error";
    }
    else {
        $json = $output['body'];
        echo $json;
    }
}


add_filter( 'bulk_actions-edit-shop_order', 'tcs_bulk_actions',101 );
function tcs_bulk_actions( $bulk_array ) {
    $dvs_tcs_enable = get_option( 'dvs_tcs_enable' );
    if ($dvs_tcs_enable == 1 ) {
        $bulk_array['mark_tcs_orders'] = 'TCS Bulk Booking';
    }
    return $bulk_array;
}


add_filter( 'handle_bulk_actions-edit-shop_order', 'dvs_tcs_bulk_action_handler', 9999, 4 );
function dvs_tcs_bulk_action_handler( $redirect, $doaction, $object_ids ) {
	if ( $doaction !== 'mark_tcs_orders' ) {
	    return $redirect;
	}
    $orders_data = [];
    $orders_items = [];
	foreach( $object_ids as $order_id ) {
        $orders_data[] = dvs_tcs_orders_data($order_id);

    }
    dvs_tcs_body_data($orders_data);
}


add_action('woocommerce_order_actions', 'tcs_single_order_action', 10, 1 );
function tcs_single_order_action( $actions ) {
    $dvs_tcs_enable = get_option( 'dvs_tcs_enable' );
    if ($dvs_tcs_enable == 1 ) {    
        if ( is_array( $actions ) ) {
            $actions['tcs_action'] = __( 'Book at TCS Courier' );
        }
    }
    return $actions;
}


add_action( 'woocommerce_order_action_tcs_action', 'tcs_single_order_booking' );
function tcs_single_order_booking($order_id) {
    $orders_data = [];
    $orders_items = [];    
    $orders_data[] = dvs_tcs_orders_data($order_id);
    dvs_tcs_body_data($orders_data);
    die();
}


add_action( 'init', 'tcs_submit_form' );
function tcs_submit_form() {    
    if(!empty($_POST['dvs_courier']) && $_POST['dvs_courier'] == 'tcs' ) {

        $orders = $_POST['order'];
        $trackings = [];
        $msgs = '';
        $count = 0;
        $uncount = 0;
        $actualcount = 0;       
        $allcount = 1;

        foreach($orders as $order) {

            if(!isset($order['check']))
            continue;

            $book_packet_array = array(
                'dvs_courier' => "TCS",
                'dvs_tcs_account' => get_option('dvs_tcs_account'),
                'dvs_tcs_auth' => get_option('dvs_tcs_auth'),             
                'dvs_tcs_token'  =>  get_option('dvs_tcs_token'),
                'dvs_tcs_location'  =>  get_option('dvs_tcs_location'),
                'order' => $order,
            );

            $booking = json_encode($book_packet_array);

            $url = get_option( 'dvs_url' ).'/woo/upload.php';
            $output = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 300,'body'=> $booking));
            if ( is_wp_error( $output ) ) {
                $error = $output->get_error_message();
                echo "Error: $error";
            }
            else {
                $json = $output['body'];
                $response = json_decode($json,true);
            }

            $order_id = $order['order_id'];
            $order_number = $order['order_number'];  

            $current_order = $order;

            if(isset($response['consignmentNo'])) {
                $order = new WC_Order($order_id);
                $tcs_tracking = $response['consignmentNo'];

                $msgs .= "<div style='background-color:#107f61; color:#ffffff; padding:5px 10px; border: 1px solid #107f61; border-radius: 5px; margin: 5px 0px';><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<span> [ Booked: ".$tcs_tracking." ]</span></div>";
                $order->add_order_note("Order has been booked at TCS Courier with Tracking # ".$tcs_tracking);
                update_post_meta( $order->get_id(), '_dvs_courier_list', 'TCS');   
                update_post_meta( $order->get_id(), '_dvs_courier_tracking', $tcs_tracking );
                update_post_meta( $order->get_id(), '_dvs_courier_check', 'Booked' );

                $dvs_courier_link = 'https://www.tcsexpress.com/track/'.$tcs_tracking;
                update_post_meta( $order->get_id(), '_dvs_courier_link', $dvs_courier_link ); 

                $dvs_label_shipper_booked = get_option('dvs_label_shipper_booked');

                if($dvs_label_shipper_booked == 1) {
                    $order->update_status( 'wc-booked' );
                }

                // Add log to db
                dvs_ucp_logs($current_order, $tcs_tracking, 'TCS');

                $trackings[] = $tcs_tracking;

                $count++;
            }
            else {
                $msgs .= "<div style='background-color:#ff4e4e; color:#ffffff; padding:5px 10px; border: 1px solid #ff4e4e; border-radius: 5px; margin: 5px 0px';'><strong>{$allcount}: </strong>Order # ".$order_number;
                $msgs .= "<br><span> [ Error: ".$json." ]</span></div>";
                $uncount++;
            }
            $allcount++;
            $actualcount++;
        }   

        if($msgs!='') { ?>

        <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto&display=swap');

        h3 {
            text-align: center;
        }

        .dvs-booking-result {
            width: 600px;
            margin: 0 auto;
            font-family: 'Roboto', sans-serif;
            margin-top: 20px;
        }               

        .dvs-btn-back {
            float: right;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #ffffff;
            color: #107f61;
            font-size: 16px;        
        }

        .dvs-btn-print {
            float: left;
            margin: 10px 0px;
            border: 1px solid #107f61;
            border-radius: 5px;
            padding: 10px 20px;
            text-align: center;
            text-decoration: none;
            background-color: #107f61;
            color: #ffffff;
            font-size: 16px;        
        }           

        </style>

        <?php
            echo '<div class="dvs-booking-result">';?>
            <center>    
            <img src="<?php echo plugin_dir_url( __DIR__ ) . 'images/tcs-label-logo.png'; ?>" height="50px">    
            <h3>TCS Booking Summary</h3>
            </center>
            <?php 
            echo "Booked Packets = {$count}";
            echo '<br/>';
            echo '<br/>';       
            echo "Un-Booked Packets = {$uncount}";
            echo '<br/>';
            echo '<br/>';
            echo $msgs;
            echo '<br/>';

            if($_SERVER['REQUEST_URI'] == '/wp-admin/post.php') {
                $btn_url = get_admin_url(null, 'post.php?post='.$order_id.'&action=edit');
            }
            else {
                $btn_url = get_admin_url(null, 'edit.php?post_type=shop_order');
            }
            $tracking_url = get_admin_url(null, 'edit.php?dvs_trackings=' . join(',', $trackings));

            $dvs_label_shipper_enable = get_option('dvs_label_shipper_enable');

            if ($dvs_label_shipper_enable == '1') {
                echo '<a href="'.$tracking_url.'" class="dvs-btn-print" target="blank">Print Label</a>';
            }
            
            echo '<a href="'.$btn_url.'" class="dvs-btn-back">Go Back</a>';
            echo '</div>';
        }

        $dvs_courier_total = get_option( 'dvs_courier_total' ) + $count;
        update_option('dvs_courier_total', $dvs_courier_total);

        $dvs_courier_tcs = get_option( 'dvs_courier_tcs' ) + $count ;
        update_option('dvs_courier_tcs', $dvs_courier_tcs);

        $url = get_option( 'dvs_url' )."/woo/count.php";
        $data_count = array(
            'dvs_courier' => 'TCS',
            'count' => $actualcount,
            'booked' => $count,
            'unbooked' => $uncount,
        );
        $data_count = json_encode($data_count);
        $post = wp_remote_post( $url, array('method'=> 'POST','sslverify' => false,'timeout'=> 30, 'body'=> $data_count ));
        die();   
    }
}
