<?php

if ( ! defined( 'ABSPATH' ) ) exit;

function dvs_after_cancel_shipment($order, $order_id, $courier, $tracking) {
    $cancel_note = 'Shipment has been cancelled at '.$courier.' Courier with Tracking # '.$tracking;
    $order->add_order_note($cancel_note);
    update_post_meta( $order->get_id(), '_dvs_courier_list', '');   
    update_post_meta( $order->get_id(), '_dvs_courier_tracking', '' );
    update_post_meta( $order->get_id(), '_dvs_courier_check', 'Un-Booked' );
    global $wpdb;
    $dbData = array();
    $dbData['courier_status'] = 'cancelled';
    $wpdb->update('dvs_ucp_logs', $dbData, array('courier_tracking' => $tracking));
    dvs_track_shipment($order_id, $courier, $tracking, $print=false);
    return $cancel_note;
}

add_action('wp_ajax_dvs_courier_cancel_tracking', 'get_dvs_courier_cancel_tracking');
function get_dvs_courier_cancel_tracking() {
    $order_id = $_POST['dvs_order_id'];
    $order = new WC_Order( $order_id );
    $order_no = $order->get_order_number();
    $courier = $_POST['dvs_courier_list'];    
    $tracking = $_POST['dvs_courier_tracking'];

// TCS
    if ($courier == 'TCS') {
        $dvs_tcs_token = get_option( 'dvs_tcs_token' );
        $dvs_tcs_auth = get_option( 'dvs_tcs_auth' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://connect.tcscourier.com/ecom/api/booking/cancel',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
            "consignmentnumber": "'.$tracking.'",
            "accesstoken": "'.$dvs_tcs_token.'"
        }',
          CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer '.$dvs_tcs_auth,
            'Content-Type: application/json'
          ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['message'] == 'SUCCESS') {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);
        }
        else {
            $cancel_responce = 'There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }

// LEOPARDS COURIER
    else if ($courier == 'Leopards Courier') {
        $dvs_lcs_portal = get_option('dvs_lcs_portal');
        $dvs_lcs_api = get_option( 'dvs_lcs_api' );
        $dvs_lcs_password = get_option( 'dvs_lcs_password' );

        $cancel_tracking = array(         
            'api_key'  =>  $dvs_lcs_api,
            'api_password'  =>  $dvs_lcs_password,
            'cn_numbers' => $tracking
        );
        $cancel_tracking = json_encode($cancel_tracking);

        if(isset($dvs_lcs_portal) && !empty($dvs_lcs_portal)) {
            if($dvs_lcs_portal == "new") {
              $lcs_url = 'https://merchantapi.leopardscourier.com/api';
            }
            else {
              $lcs_url = 'http://new.leopardscod.com/webservice';
            }
        }
        else {
            $lcs_url = 'https://merchantapi.leopardscourier.com/api';
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $lcs_url . '/cancelBookedPackets/format/json/',            
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $cancel_tracking,
        CURLOPT_HTTPHEADER => array(
        'accept: application/json ',   
        'Content-Type: application/json'
            ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($result, true);

        if($response['status'] == 0) {
            $curl = curl_init();
            curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://new.leopardscod.com/webservice/cancelBookedPackets/format/json/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $cancel_tracking,
            CURLOPT_HTTPHEADER => array(
            'accept: application/json ',   
            'Content-Type: application/json'
                ),
            ));
            $result = curl_exec($curl);
            curl_close($curl);
            $response = json_decode($result, true);
        }

        if($response['status'] == 1) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);
        }
        else {
            $cancel_responce = 'There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }

// TRAX
    else if ($courier == 'Trax') {
        $dvs_trax_api = get_option( 'dvs_trax_api' );
        $cancel_tracking = array(         
            'tracking_number' => $tracking
        );
        $cancel_tracking = json_encode($cancel_tracking);

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://sonic.pk/api/shipment/cancel',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $cancel_tracking,
        CURLOPT_HTTPHEADER => array(
        'Authorization: '.$dvs_trax_api,
        'Content-Type: application/json'
            ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['status'] == 0) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }

// MNP
    else if ($courier == 'MNP') {
        $dvs_mnp_account = get_option( 'dvs_mnp_account' );
        $dvs_mnp_username = get_option( 'dvs_mnp_username' );
        $dvs_mnp_password = get_option( 'dvs_mnp_password' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'http://mnpcourier.com/mycodapi/api/Locations/Get_locations?username='.$dvs_mnp_username.'&password='.$dvs_mnp_password.'&AccountNo='.$dvs_mnp_account,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $location_result = curl_exec($curl);
        curl_close($curl);
        $location_result = json_decode($location_result, true);
        $location = $location_result['locationList'][0]['locationID'];
        $cancel_tracking = array(
            'Username' => $dvs_mnp_username,
            'password' => $dvs_mnp_password,
            'locationID' => $location,
            'consignmentNumberList' => array(
                $tracking,
            ),
        );
        $cancel_tracking = json_encode($cancel_tracking);

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'http://mnpcourier.com/mycodapi/api/Booking/VoidConsignment',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => $cancel_tracking,
        CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json'
        ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);
        
        $response = json_decode($result, true);

        if($response[0]['isSuccess'] == true) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }

// CALL COURIER
    else if ($courier == 'Call Courier') {
        $cancel_responce = 'Note: Shipment has been removed from shipment logs and marked as unbooked but it is still available in Call Courier Portal as Cancel shipment is not supported in Call Courier API. You need to manually remove from Call Courier Portal.';
        $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);
    }


// CALL COURIER
    else if ($courier == 'Oshi Courier') {
        $cancel_responce = 'Note: Shipment has been removed from shipment logs and marked as unbooked but it is still available in Oshi Courier Portal as Cancel shipment is not supported in Oshi Courier API. You need to manually remove from Oshi Courier Portal.';
        $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);
    }


// BLUEEX
    else if ($courier == 'BlueEx') {
        $dvs_blx_api = get_option( 'dvs_blx_api' );
        $dvs_blx_account = get_option( 'dvs_blx_account' );

        $blx_token = base64_encode($dvs_blx_account . ':' . $dvs_blx_api);

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://bigazure.com/api/json_v3/cancel/void.php',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{"consignment_no": "'.$tracking.'"}',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Basic '.$blx_token
          ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if ($response['status'] == 1) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);
        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }

// SWYFT LOGISTICS 
    else if ($courier == 'Swyft Logistics') {
        $dvs_swyft_api = get_option( 'dvs_swyft_api' );
        $dvs_swyft_vendor = get_option( 'dvs_swyft_vendor' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://vendor-api.swyft-logistics.com/api/'.$dvs_swyft_vendor.'/cancel-parcel/'.$tracking,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_HTTPHEADER => array(
        'Authorization: '.$dvs_swyft_api,
        'Content-Type: application/json'
            ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['message'] == 'Success' && $response['extraInfo']['description'] !== 'Provided parcel ID is incorrect.' ) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);
        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }


// POSTEX
    else if ($courier == 'PostEx') {
        $dvs_postex_token = get_option( 'dvs_postex_token' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.postex.pk/services/integration/api/order/v1/cancel-order',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'PUT',
        CURLOPT_POSTFIELDS =>'{"trackingNumber": "' . $tracking . '"}',
        CURLOPT_HTTPHEADER => array(
        'token: '.$dvs_postex_token,
        'Content-Type: application/json'
        ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['statusCode'] == '200') {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }       

// DAEWOO COURIER
    else if ($courier == 'Daewoo Courier') {
        $dvs_daewoo_api = get_option( 'dvs_daewoo_api' );
        $dvs_daewoo_username = get_option( 'dvs_daewoo_username' );
        $dvs_daewoo_password = get_option( 'dvs_daewoo_password' );

        $curl_url = 'https://codapi.daewoo.net.pk/api/booking/quickCancel?apiKey='.$dvs_daewoo_api.'&apiUser='.$dvs_daewoo_username.'&apiPassword='.$dvs_daewoo_password.'&trackingNo='.$tracking;
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $curl_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => '',
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['Success'] == true) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }




// DO DELIVER
    else if ($courier == 'Do Deliver') {
        $dvs_dodeliver_token = get_option( 'dvs_dodeliver_token' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://portal.dodeliver.com.pk/api/orders/cancel?api_key='.$dvs_dodeliver_token,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "tracking_ids": ["'.$tracking.'"]
        }',
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json',
            'Content-Type: application/json'
        ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['status'] == true) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }


// COURIERX
   else if ($courier == 'Courierx') {
        $dvs_ccx_account = get_option('dvs_ccx_account');

        $curl_url = 'http://cod.courierx.pk/api/PortalAPI/CancelBooking?ClientCode='.$dvs_ccx_account.'&CN='.$tracking;
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => $curl_url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['ErrorMsg'] == "Booking has been cancelled") {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);
        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }

// MOVEX
    else if ($courier == 'Movex') {
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://tracking.movexpk.com/api/shipment/cancel',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
            "consignment_numbers":["'.$tracking.'"]  
        }
        ',
          CURLOPT_HTTPHEADER => array(
            'Authorization: '.get_option( 'dvs_movex_api' ),
            'Content-Type: application/json',
          ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($response, true);

        if($response['message'] == 'Shipment(s) has been Cancelled') {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }


// BOURAQ EXPRESS
else if ($courier == 'Bouraq Express') {

    $dvs_bouraq_api = get_option('dvs_bouraq_api');

    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://bouraqcod.com/portal/API/CancelOrder.php?auth_key='.$dvs_bouraq_api.'&tracking_no='.$tracking,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 10,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        ''
      ),
    ));
    $result = curl_exec($curl);
    curl_close($curl);

    $response = json_decode($result, true);

    if(isset($response['tracking_no'])) {
        $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

    }
    else {
        $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
    }
}



// Barq Raftaar
    else if ($courier == 'Barq Raftar') {

        $dvs_barqraftar_api = get_option( 'dvs_barqraftar_api' );
        $dvs_barqraftar_secret = get_option( 'dvs_barqraftar_secret' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://barqraftar.pk/api/v1/orders/bulk_change_status',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "total_orders":1,
            "orders" : [
                {
                    "tracking_number":"'.$tracking.'",
                    "status":"cancelled"
                }
            ]
        }',
        CURLOPT_HTTPHEADER => array(
            'key: '.$dvs_barqraftar_api,
            'secret: '.$dvs_barqraftar_secret,
            'Content-Type: application/json'
        ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if($response['success_orders_count'] == 1) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }



// Zaaf Courier
    else if ($courier == 'Zaaf Courier') {

        $dvs_zaaf_api = get_option('dvs_zaaf_api');

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://zaaf.pk/API/CancelOrder.php?auth_key='.$dvs_zaaf_api.'&tracking_no='.$tracking,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            ''
          ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($result, true);

        if(isset($response['tracking_no'])) {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }



// RIDER
    else if ($courier == 'Rider') {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://api.withrider.com/rider/v1/CancelBooking?CNNo='.$tracking.'&loginId='.get_option('dvs_rider_login').'&apikey='.get_option('dvs_rider_api'),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($response, true);

        if($response['message'] == 'Transaction Successful') {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }



// AHL COURIER
    else if ($courier == 'AHL Courier') {

        $get_dvs_ahl_email = get_option('dvs_ahl_email');
        $get_dvs_ahl_password = get_option('dvs_ahl_password');

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://admin.ahlogistic.pk/api/shopify-vendor-access-token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('email' => $get_dvs_ahl_email,'password' => $get_dvs_ahl_password),
        ));
        $ahl_response = curl_exec($curl);
        curl_close($curl);
        $ahl_result = json_decode($ahl_response, true);

        $access_token = $ahl_result['access_token'];

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://admin.ahlogistic.pk/api/shopify-order-cancel',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('order_reference_no' => '#'.$tracking),
          CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer '.$access_token
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $response = json_decode($response, true);

        if($response['message'] == 'Order Cancel Successfully') {
            $cancel_responce = dvs_after_cancel_shipment($order, $order_id, $courier, $tracking);

        }
        else {
            $cancel_responce = 'Error: There is an error during cancellation. Try again or contact support. <br><br>'.$result;
        }
    }

    else {
        $cancel_responce = 'Error: Cancellation is not supported';
    } 


    $current_page = admin_url( "post.php?post=".$order_id.'&action=edit' );

    echo '<center>';
    echo '<h3>Cancellation Result</h3>';
    echo $cancel_responce;
    echo '<br>';
    echo '<br>';
    echo 'Please click on Refresh Button to finalize cancellation process.';
    echo '<br>';
    echo '<br>';
    echo '<a href="'.$current_page.'" class="button-primary">Refresh</a>';
    echo '</center>';
    exit();
}