<html>
<head>
    <meta charset="utf-8">
    <title>A4 - Loadsheet</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto+Condensed:wght@400;700&display=swap" rel="stylesheet">

    <style>
        /*! normalize.css v7.0.0 | MIT License | github.com/necolas/normalize.css */html{line-height:1.15;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}body{margin:0}article,aside,footer,header,nav,section{display:block}h1{font-size:2em;margin:.67em 0}figcaption,figure,main{display:block}figure{margin:1em 40px}hr{box-sizing:content-box;height:0;overflow:visible}pre{font-family:monospace,monospace;font-size:1em}a{background-color:transparent;-webkit-text-decoration-skip:objects}abbr[title]{border-bottom:none;text-decoration:underline;text-decoration:underline dotted}b,strong{font-weight:inherit}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace,monospace;font-size:1em}dfn{font-style:italic}mark{background-color:#ff0;color:#000}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}audio,video{display:inline-block}audio:not([controls]){display:none;height:0}img{border-style:none}svg:not(:root){overflow:hidden}button,input,optgroup,select,textarea{font-family:sans-serif;font-size:100%;line-height:1.15;margin:0}button,input{overflow:visible}button,select{text-transform:none}[type=reset],[type=submit],button,html [type=button]{-webkit-appearance:button}[type=button]::-moz-focus-inner,[type=reset]::-moz-focus-inner,[type=submit]::-moz-focus-inner,button::-moz-focus-inner{border-style:none;padding:0}[type=button]:-moz-focusring,[type=reset]:-moz-focusring,[type=submit]:-moz-focusring,button:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:.35em .75em .625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}progress{display:inline-block;vertical-align:baseline}textarea{overflow:auto}[type=checkbox],[type=radio]{box-sizing:border-box;padding:0}[type=number]::-webkit-inner-spin-button,[type=number]::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}[type=search]::-webkit-search-cancel-button,[type=search]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}details,menu{display:block}summary{display:list-item}canvas{display:inline-block}template{display:none}[hidden]{display:none}/*# sourceMappingURL=normalize.min.css.map */
        @page { margin: 0 }
        body { margin: 0 }
        .sheet {
          margin: 0;
          overflow: hidden;
          position: relative;
          box-sizing: border-box;
          page-break-after: always;
        }

        /** Paper sizes **/
        body.A3               .sheet { width: 297mm; height: 419mm }
        body.A3.landscape     .sheet { width: 420mm; height: 296mm }
        body.A4               .sheet { width: 210mm; height: 296mm }
        body.A4.landscape     .sheet { width: 297mm; height: 209mm }
        body.A5               .sheet { width: 148mm; height: 209mm }
        body.A5.landscape     .sheet { width: 210mm; height: 147mm }
        body.letter           .sheet { width: 216mm; height: 279mm }
        body.letter.landscape .sheet { width: 280mm; height: 215mm }
        body.legal            .sheet { width: 216mm; height: 356mm }
        body.legal.landscape  .sheet { width: 357mm; height: 215mm }
        body.single           .sheet { width: 210mm; height: auto }

        /** Padding area **/
        .sheet.padding-5mm  { padding: 5mm }
        .sheet.padding-10mm { padding: 10mm }
        .sheet.padding-15mm { padding: 15mm }
        .sheet.padding-20mm { padding: 20mm }
        .sheet.padding-25mm { padding: 25mm }

        /** For screen preview **/
        @media screen {
          body { background: #e0e0e0 }
          .sheet {
            background: white;
            box-shadow: 0 .5mm 2mm rgba(0,0,0,.3);
            margin: 5mm auto;
          }
        }

        /** Fix for Chrome issue #273306 **/
        @media print {
                   body.A3.landscape { width: 420mm }
          body.A3, body.A4.landscape { width: 297mm }
          body.A4, body.A5.landscape { width: 210mm }
          body.A5                    { width: 148mm }
          body.letter, body.legal    { width: 216mm }
          body.letter.landscape      { width: 280mm }
          body.legal.landscape       { width: 357mm }
          body.single                { width: 200mm }
        }

        /* @page { 
            size: A5;
        } */

        body {
            font-family: 'Roboto Condensed', sans-serif;
            font-weight: normal;
            font-size: 12px;
        }

        strong {
            font-weight: bold;
        }

        .label-box {
            width: 100%;
            float: left;
        }

        .container {
            width: 7.7in;
            float: left;
            margin: 5px;
        }

        .col-100 {
            width: 100%;
            float: left;
        }

        .col-75 {
            width: 75%;
            float: left;
        }

        .col-50 {
            width: 50%;
            float: left;
        }

        .col-25 {
            width: 25%;
            float: left;
        }

        .col-33 {
            width: 33.33%;
            float: left;
        }

        .col-16 {
            width: 16.66%;
            float: left;
        }

        .border-box {
            height: 100%;
            border: 1px solid #000000;
        }

        .border-lr {
            border-left: 1px solid #000000;
            border-right: 1px solid #000000;
        }

        .border {
            border: 1px solid #000000;
        }

        .border-top {
            border-top: 1px solid #cccccc;
        }

        .border-bottom {
            border-bottom: 1px solid #cccccc;
        }

        .border-dotted {
            font-size: 16px;
            border: 1px dotted #000000;
        }

        .center {
            text-align: center !important;
        }

        .height-logo {
            height: 100px;
        }

        .height-address {
            height: 50px;
        }

        .height-100 {
            height: 100%;
        }

        .height-300 {
            height: 2in;
        }

        .height-50 {
            height: 50px;
        }

        .height-75 {
            height: 75px;
        }       

        .height-50 {
            height: 50px;
            line-height: 15px;
        }

        .height-30 {
            height: 30px;
            line-height: 15px;
        }

        .inch-half {
            height: .5in;
        }

        .inch-060 {
            height: .6in;
        }

        .inch-075 {
            height: .75in;
        }        

        .inch-2 {
            height: 2.15in;
        }       

        .justify {
            justify-content: center;
            align-items: center;
            display: flex;          
        }

        .logo {
            width: 75px;
            height: 75px;
        }


        .mtb-10 {
            margin: 0px 10px;
        }

        .ptb-10 {
            padding: 10px 0px;
        }

        .ptb-5 {
            padding: 5px 0px;
        }

        .pb-2 {
            padding-bottom: 2px;
        }
        
        .pb-5 {
            padding-bottom: 5px;
        }           

        .ptblr-10 {
            padding: 10px;
        }

        .ptblr-5 {
            padding: 5px;
        }

        .ptblr-3 {
            padding: 3px;
        }       

        .font-10 {
            font-size: 10px;
        }

        .font-12 {
            font-size: 12px;
        }

        .font-13 {
            font-size: 13px;
        }

        .font-14 {
            font-size: 14px;
        }       

        .font-15 {
            font-size: 15px;
        }

        .font-16 {
            font-size: 16px;
        }        

        .font-20 {
            font-size: 20px;
        }               

        .center {
            text-align: center !important;
        }

        .border-1 {
            border-top: none;
            border-left: none;
            border-right: none;         
        }

        .border-2 {
            border-top: none;
            border-bottom: none;
            border-right: none;         
        }

        .border-3 {
            border-top: none;
            border-bottom: none;
        }

        .float-right {
            float: right;
        }

        .parcel-margin {
            margin-bottom: 0.5in;
        }


/* Invoice Section */
.container-invoice {
    width: 7.5in;
    height: auto;
    float: left;
    margin: 10px;
}


.invoice-page {
    margin-top: 0px;
}

.details-container {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
}

.details-section {
    border: 1px solid black;
    padding: 10px;
    box-sizing: border-box;
}

.details-section p {
    margin: 5px;
    line-height: 15px;
}

.customer-details {
    width: 50%;
    line-height: 16px;
}



.details-header {
    position: relative; /* To position the logo relative to the header */
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.details-header-start,
.details-header-end {
    flex: 1; /* Equal width for left and right sections */
}

.details-header-center {
    position: absolute; /* Center the logo absolutely within the header */
    left: 54%;
    transform: translateX(-50%);
    text-align: center;
}

.details-header-start {
    line-height: 15px;
}

.details-header-center img {
    max-height: 30px;
    max-width: 100%;
    object-fit: contain;
}

.details-header-end {
    text-align: right;
    font-size: 14px;
    line-height: 1.5;
}


.order-details {
    width: 30%;
}

.order-details p {
    font-size: 12px;
}

.courier-details {
    width: 40%;
}

.courier-details p {
    font-size: 14px;
}

.details-section h3 {
    margin-top: 0;
}

/* Main Table */
.styled-table {
    width: 100%; /* The main table spans 100% */
    border-collapse: collapse;
    margin-bottom: 20px;
}

.styled-table th,
.styled-table td {
    border: 1px solid black;
    padding: 5px 10px;
    font-size: 12px;
    text-align: left;
}

.styled-table th {
    background-color: #f4f4f4;
    font-weight: bold;
}

.styled-table td {
    vertical-align: top;
}

/* Summary Table */
.right-table-container {
    width: 31.5%; /* The right-side table takes 40% of the width */
    margin-left: auto; /* Align the container to the right */
}

.summary-table {
    width: 100%;
    border-collapse: collapse;
}

.summary-table td {
    border: 1px solid black;
    padding: 5px 10px;
    text-align: left;
    font-size: 12px;
}

.summary-table td:first-child {
    font-weight: bold;
    background-color: #f4f4f4;
}

.qty-column {
    width: 30px; /* Fixed width for 4 numbers */
    text-align: center !important;
}

.price-column {
    width: 60px; /* Fixed width for 4 numbers */
}

.sku-column {
    width: 125px; /* Fixed width for 4 numbers */
}

    </style>
</head>

<body class="single">
    <section id="loadsheet" class="sheet padding-5mm">
        <div class="container">
            <img src="<?= $courier_logo; ?>" style="width: 100px">
            <h2 class="center" style="margin: 0px">Loadsheet</h2>
            <p class="center"><strong>Date:</strong> <?= $loadsheet_date; ?></p>
            <div class="container">
                <div class="col-33">
                    <p><strong>Courier Name:</strong> <?= $courier_name; ?></p>
                    <p><strong>Total Shipments:</strong> <?= count($parcels) ?></p>
                    <?php
                        $total_amount = 0; 
                        $total_cod = 0;
                        foreach($parcels as $parcel) {
                            $total_cod += (int)$parcel->order_amount;
                            $total_amount += (int)$parcel->order_total;
                        }
                    ?>
                    <p><strong>Orders Total:</strong> Rs <?= $total_amount ?></p>
                    <p><strong>Orders COD:</strong> Rs <?= $total_cod ?></p>
                </div>          
                <div class="col-33">
                    <p><strong>Brand Name:</strong> ____________________________</p>
                    <p><strong>Brand Phone:</strong> ____________________________</p>
                    <br>
                    <p><strong>Brand Signature:</strong> ____________________________</p>
                </div>      
                <div class="col-33">
                    <p><strong>Rider Name:</strong> ____________________________</p>
                    <p><strong>Rider Phone:</strong> ____________________________</p>
                    <br>
                    <p><strong>Rider Signature:</strong> ____________________________</p>
                </div>
            </div>
            <table class="styled-table">
                <thead class="table-dark">
                    <tr>
                        <th></th>
                        <th>Booked</th>
                        <th>Name</th>
                        <th>Order #</th>
                        <th>Amount</th>
                        <th>COD</th>
                        <th class="center">Weight</th>
                        <th>City</th>
                        <th class="center">Tracking</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $count = 1;
                foreach($parcels as $index => $parcel) { 
                    ?>
                    <tr>
                        <td class="center"><?= $count ?></td>
                        <td><?= date("d-m-Y", strtotime($parcel->courier_datetime)) ?></td>
                        <td><?= $parcel->consignee_name ?></td>
                        <td><?= $parcel->order_name ?></td>
                        <td>Rs <?= (int) $parcel->order_total ?></td>
                        <td>Rs <?= (int) $parcel->order_amount ?></td>
                        <td class="center"><?= $parcel->order_weight ?></td>
                        <td><?= $parcel->courier_destination ?></td>
                        <td class="center"><?= $parcel->courier_tracking ?></td>
                    </tr>
                <?php
                $count ++;
                }
                ?>
                </tbody>
            </table>
        </div>
    </section>
</body>