<?php
/**
 * Order tracking
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/tracking.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 2.2.0
 */

defined( 'ABSPATH' ) || exit;

$courier = get_post_meta( $order->get_id(), '_dvs_courier_list', true );
$tracking = get_post_meta( $order->get_id(), '_dvs_courier_tracking', true );

echo '<div class="dvs-track-page">';
echo '<p>Hello ' . $order->get_billing_first_name() . ', Your order #' . $order->get_order_number() . ' was placed on ' . wc_format_datetime( $order->get_date_created() ) . ' has been ' . wc_get_order_status_name( $order->get_status() ) . '.</p>';

if( ! empty( $courier ) ) {
    echo '<p>Your order has been shipped via '. $courier .' and Consignment Number is '. $tracking .' </p>';
    echo '<div class="dvs-100">'; ?>

    <style>
        .dvs-track-box-table {
            margin: 15px 0px;
        }
        .dvs-track-box-table th {
            border: 1px solid #555555;
        }
        .dvs-track-box-table td {
            border: 1px solid #cccccc;
        }
        .track-thickbox .status {
            width: auto;
            border: 2px solid #a0cc5b;
            font-weight: bold;
            padding: 10px;
            margin: 15px 0px;
            border-radius: 5px;
            text-align: center;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
    </style>

<div id="dvs-track-box">
    <div class="track-thickbox">
    <?php

// TCS COURIER
    if ($courier == 'TCS') {

        $dvs_tcs_auth = get_option( 'dvs_tcs_auth' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://connect.tcscourier.com/tracking/api/Tracking/GetDynamicTrackDetail?consignee='.$tracking.'&timezone=true',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$dvs_tcs_auth
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);        

        $data = json_decode($response, true);

        if($data['message'] == "SUCCESS") {

            if(isset($data['deliveryinfo'])) {
                $current_status = trim($data['deliveryinfo'][0]['status']);
            }
            else if(isset($data['checkpoints'])) {
                $current_status = trim($data['checkpoints'][0]['status']);
            }                        
            else {
                $current_status = 'Shipment - Booked';
            }

            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>';
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';

            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

            if(isset($data['checkpoints'])) {
                foreach ($data['checkpoints'] as $status) {
                    $output.=   '<tr>';
                    $output.=   '<td>' .$status['datetime']. '</td>';                       
                    $output.=   '<td>' .$status['status']. '</td>';
                    $output.=   '<td>' .$status['recievedby']. '</td>';
                    $output.=   '</tr>';                                 
                }
            }
            $output.=   '</table>';
            echo $output;
        }
        else {
            echo 'Invalid Result';
        }
    }

// LEOPARDS COURIER
    else if ($courier == 'Leopards Courier') {

        $dvs_lcs_portal = get_option('dvs_lcs_portal');
        $dvs_lcs_api = get_option('dvs_lcs_api');
        $dvs_lcs_password = get_option('dvs_lcs_password');

        $curl = curl_init();
            curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://merchantapi.leopardscourier.com/api/trackBookedPacket/format/json/',           
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('api_key' => $dvs_lcs_api,'api_password' => $dvs_lcs_password,'track_numbers' => $tracking),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($response, true);

        if ($data['status'] == 1 ) {    
            foreach ($data['packet_list'] as $a) {

                $current_status = '';
                if (isset($a['Tracking Detail']) && is_array($a['Tracking Detail']) && count($a['Tracking Detail']) > 0) {
                    $current_status = trim(end($a['Tracking Detail'])['Status']) ?? '';
                } elseif (isset($a['booked_packet_status'])) {
                    $current_status = $a['booked_packet_status'];
                }

                $output = '';
                $output.=   '<div class="order-details">';                       
                $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
                $output.=   '<div class="name"><strong>Name: </strong>' .$a['consignment_name_eng']. '</div>';
                $output.=   '<div class="phone"><strong>Phone: </strong>' .$a['consignment_phone']. '</div>';
                $output.=   '</div>';
                $output.=   '<div class="tracking-details">';                       
                $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
                $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
                $output.=   '<div class="city"><strong>Destination: </strong>' .$a['destination_city_name']. '</div>';
                $output.=   '</div>'; 
                $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
                $output.=   '<table class="dvs-track-box-table" class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
                foreach ($a['Tracking Detail'] as $b) {
                    $output.=   '<tr>';                
                    $output.=   '<td>' .$b['Activity_datetime']. '</td>';
                    $output.=   '<td>' .$b['Status']. '</td>';                
                    $output.=   '<td>' .@$b['Reason']. ' ' .@$b['Reciever_Name']. '</td>';
                    $output.=   '</tr>';                                 
                }
                $output.=   '</table>';
            }
            echo $output;
        }
        else {
            echo 'Invalid Result';
        }
    }

// TRAX
    else if ($courier == 'Trax') {
        $apiKey = get_option( 'dvs_trax_api' );
        $apiUrl = "https://sonic.pk/api/shipment/track?tracking_number=".$tracking."&type=0";
        $headers = ['Authorization:' . $apiKey, 'Accepts:' . 'application/json'];
        $curl = curl_init();
        curl_setopt($curl,CURLOPT_URL, $apiUrl);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($response, true);

        if ($data['status'] == 0 ) {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['details']['tracking_history'][0]['status']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data['details']['tracking_history'] as $a) {
                $output.=   '<tr>';
                $output.=   '<td>' .$a['date_time']. '</td>';                       
                $output.=   '<td>' .$a['status']. '</td>';
                $output.=   '<td>' .$a['status_reason']. '</td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';            
            echo $output;
        }
        else {
            echo 'Invalid Result';
        }
    }

// MNP    
    else if ($courier == 'MNP') {
        $dvs_mnp_username = urlencode(get_option('dvs_mnp_username'));
        $dvs_mnp_password = urlencode(get_option('dvs_mnp_password'));
        $dvs_mnp_url = "http://mnpcourier.com/mycodapi/api/Tracking/Consignment_Tracking?Username=".$dvs_mnp_username."&password=".$dvs_mnp_password."&consignment=".$tracking."";
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $dvs_mnp_url);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($response, true);
        $data = $data[0];

        if ($data['isSuccess'] == 'true') {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['tracking_Details'][0]['CNStatus']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data['tracking_Details'][0]['Details'] as $a) {
                $output.=   '<tr>';
                $output.=   '<td>' .$a['DateTime']. '</td>';                       
                $output.=   '<td>' .$a['Status']. '</td>';
                $output.=   '<td>' .$a['Location']. ' ' .$a['Detail']. '</td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';            
            echo $output;
        }
        else {
            echo 'Invalid  Result';
        }
    }

// CALL COURIER    
    else if ($courier == 'Call Courier') {
        $dvs_call_courier_url = "http://cod.callcourier.com.pk/api/CallCourier/GetTackingHistory?cn=".$tracking."";
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $dvs_call_courier_url);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($response, true);

        $output = '';        
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .end($data)['ProcessDescForPortal']. '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data as $a) {
            $output.=   '<tr>';
            $output.=   '<td>' .$a['TransactionDate']. '</td>';                       
            $output.=   '<td>' .$a['ProcessDescForPortal']. '</td>';
            $output.=   '<td>' .$a['OperationDesc']. ' ' .$a['ReceiverName'].'</td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';            
        echo $output;
    }

// BLUEEX    
    else if ($courier == 'BlueEx') {

        $dvs_blx_api = get_option( 'dvs_blx_api' );
        $dvs_blx_account = get_option( 'dvs_blx_account' );
        $blx_token = base64_encode($dvs_blx_account . ':' . $dvs_blx_api);

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://bigazure.com/api/json_v3/tracking/get_tracking.php',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{"consignment_no": "'.$tracking.'"}',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Basic ='.$blx_token
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response,true);

        if($data['status'] == 1) {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['response'][0]['status_message']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Date</th><th>Time</th><th>Status</th></tr>';
            foreach ($data['response'] as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .$status['status_date']. '</td>';                       
                $output.=   '<td>' .$status['status_time']. '</td>';
                $output.=   '<td>' .$status['status_message']. '</td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = "Error: Invalid Result";
        }
        echo $output;
    }

// SWYFT LOGISTICS    
    else if ($courier == 'Swyft Logistics') {
        $vendor_id = get_option( 'dvs_swyft_vendor' );
        $api_secret = get_option( 'dvs_swyft_api' );        
        $url = 'https://vendor-api.swyft-logistics.com/api/'.$vendor_id.'/get-parcel-histroy/'.$tracking.'';
        $curl = curl_init(); 
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);        
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
         'Authorization: '.$api_secret.'',
         'Content-Type: application/json'
         ));
        $response = curl_exec($curl);
        curl_close($curl);   
        $data = json_decode($response,true);   

        $output = '';        
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .end($data)['status']. '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data as $a) {
            $output.=   '<tr>';
            $output.=   '<td>' .substr($a['date'],0,-14).'</td>';                       
            $output.=   '<td>' .$a['status']. '</td>';
            $output.=   '<td></td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';            
        echo $output;
    }

// DAEWOO COURIER    
    else if ($courier == 'Daewoo Courier') {       
        $url = 'https://codapi.daewoo.net.pk/api/booking/quickTrack?trackingNo='.$tracking.'';
        $curl = curl_init(); 
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);        
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
         'Content-Type: application/json'
         ));
        $response = curl_exec($curl);
        curl_close($curl);   
        $data = json_decode($response,true);

        $output = '';        
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order_no. '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['Result']['CurrentTrackStatus'][0]['status_name']. '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data['Result']['TrackingDetails'] as $a) {
            $output.=   '<tr>';
            $output.=   '<td>' .$a['PortalDate']. '</td>';                       
            $output.=   '<td>' .$a['Status'].'</td>';
            $output.=   '<td>' .$a['Status_Reason']. ' - ' .$a['remarks'].'</td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';            
        echo $output;
    }


// POSTEX    
    else if ($courier == 'PostEx') {
        $url = "https://api.postex.pk/services/integration/api/order/v1/track-order/".$tracking;
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
            'token: '.get_option('dvs_postex_token')
            ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($result, true);

        if($data['statusCode'] == 200) {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .end($data['dist']['transactionStatusHistory'])['transactionStatusMessage']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data['dist']['transactionStatusHistory'] as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .substr($status['updatedAt'],0,-18). '</td>';                       
                $output.=   '<td>' .$status['transactionStatusMessage']. '</td>';
                $output.=   '<td>' .$status['transactionStatusMessageCode']. '</td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }  



// INSTA WORLD    
    else if ($courier == 'Insta World') {

        $dvs_insta_token = get_option('dvs_insta_token');

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://one-be.instaworld.pk/logistics/v1/trackShipment',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
            "api_key": "'.$dvs_insta_token.'",
            "tracking_number": "'.$tracking.'"
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
          ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($result, true);

        if(isset($data[0]['status'])) {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .end($data)['status']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .$status['date_time']. '</td>';                     
                $output.=   '<td>' .$status['status']. '</td>';
                $output.=   '<td></td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }  





// DO DELIVER  
    else if ($courier == 'Do Deliver') {

        $dvs_dodeliver_token = get_option('dvs_dodeliver_token');

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://portal.dodeliver.com.pk/api/orders/'.$tracking.'?api_key='.$dvs_dodeliver_token,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
        'Accept: application/json'
        ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($result, true);

        if ($data['status'] === true) {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['order_detail']['status_name']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data['timeline'][0]['status'] as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .$status['time']. '</td>';                     
                $output.=   '<td>' .$status['log']. '</td>';
                $output.=   '<td></td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }  




// FALCOMAIL  
    else if ($courier == 'Falcomail') {

        $dvs_falcomail_token = get_option('dvs_falcomail_token');

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://app.falcomail.com.pk/api/TrackOrder',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 5,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => '{
            "tracking_no": "'.$tracking.'"
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
          ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($result, true);

        if($data['result']['status'] != "error") {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['result'][0]['status']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data['result'] as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .$status['created']. '</td>';                     
                $output.=   '<td>' .$status['status']. '</td>';
                $output.=   '<td></td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }  






// COURIERX
    else if ($courier == 'Courierx') {
        $url = 'https://cod.courierx.pk/api/PortalAPI/GetCNTracking?CN='.$tracking.'';
        $curl = curl_init(); 
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);        
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
         'Content-Type: application/json'
         ));
        $response = curl_exec($curl);
        curl_close($curl);   
        $data = json_decode($response,true);

        $output = '';        
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['Status']. '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Status</th><th>Time</th><th>Comments</th></tr>';

        $line = 0;

        foreach ($data['Details'] as $a) {
            $output.=   '<tr>';
            $output.=   '<td>' .$data['Details'][0]. '</td>';
            $line = $line + 1;
            $output.=   '<td>' .$data['Details'][1]. '</td>';
            $output.=   '<td> - </td>';
            $output.=   '</tr>';
            $line++;
        }             
        $output.=   '</table>';            
        echo $output;
    }

// MOVEX
    else if ($courier == 'Movex') {
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://tracking.movexpk.com/api/track/consignments?consignment_numbers='.$tracking,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'Authorization: '.get_option('dvs_movex_api') 
        ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($result, true);

        $output = '';
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .$data['response']['success'][0]['tracking_details']['order_status']. '</div>';

        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data['response']['success'][0]['tracking_details']['tracking_info'] as $status) {
            $output.=   '<tr>';
            $output.=   '<td>' .$status['created_datetime']. '</td>';                       
            $output.=   '<td>' .$status['order_status']. '</td>';
            $output.=   '<td>' .$status['message']. '</td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';
        echo $output;
    }

// RIDER
    else if ($courier == 'Rider') {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://api.withrider.com/rider/v1/GetTackingHistory?cn='.$tracking.'&loginId='.get_option( 'dvs_rider_login' ).'&apikey='.get_option( 'dvs_rider_api' ),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 10,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $result = curl_exec($curl);
        curl_close($curl);
        $data = json_decode($result, true);
        $data = array_reverse($data);

        $output = '';
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .$data[0]['order_status']. '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

        foreach ($data as $status) {
            $output.=   '<tr>';
            $output.=   '<td>' .$status['updated_at']. '</td>';                       
            $output.=   '<td>' .$status['order_status']. '</td>';
            $output.=   '<td>' .$status['reason']. '</td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';
        echo $output;
    }


// AHL COURIER
    else if ($courier == 'AHL Courier') {

        $get_dvs_ahl_email = get_option('dvs_ahl_email');
        $get_dvs_ahl_password = get_option('dvs_ahl_password');

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://admin.ahlogistic.pk/api/shopify-vendor-access-token',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('email' => $get_dvs_ahl_email,'password' => $get_dvs_ahl_password),
        ));
        $ahl_response = curl_exec($curl);
        curl_close($curl);
        $ahl_result = json_decode($ahl_response, true);

        $access_token = $ahl_result['access_token'];

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://admin.ahlogistic.pk/api/shopify-order-track',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('order_reference_no' => '#'.$tracking),
          CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer '.$access_token
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response, true);

        $current_status = trim($data['order_track']['order_status']['name']);

        $output = '';
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
        // $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

        // foreach ($data as $status) {
        //     $output.=   '<tr>';
        //     $output.=   '<td>' .$status['updated_at']. '</td>';                       
        //     $output.=   '<td>' .$status['order_status']. '</td>';
        //     $output.=   '<td>' .$status['reason']. '</td>';
        //     $output.=   '</tr>';                            
        // }             
        $output.=   '</table>';
        echo $output;
    }



// RGS LOGISTICS TRACKING
else if ($courier == 'RGS Logistics') {

    $get_dvs_rgs_email = get_option('dvs_rgs_email');
    $get_dvs_rgs_password = get_option('dvs_rgs_password');

    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://codsolution.co/ship/Api/loginApi?email='.urlencode($get_dvs_rgs_email).'&password='.urlencode($get_dvs_rgs_password),
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_HTTPHEADER => array(),
    ));
    $response = curl_exec($curl);
    curl_close($curl);

    $result = json_decode($response, true);

    if($result['status'] == 'success') {

        $bearer_token = $result['bearer_token'];

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://codsolution.co/ship/Api/track_parcel/?tracking_number='.$tracking,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer '.$bearer_token
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response, true);

        if (isset($data[0]['Status'])) {
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$data[0]['Status']. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .$status['date']. '</td>';                 
                $output.=   '<td>' .$status['Status']. '</td>';
                $output.=   '<td>' .$status['comment']. '</td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;        
    }
}



// ROCKET COURIER
    else if ($courier == 'Rocket Courier') {

        $dvs_rocket_shipper_api = get_option( 'dvs_rocket_shipper_api' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://app.couriermanager.eu/cscourier/API/get_history?api_key='.$dvs_rocket_shipper_api.'&awbno='.$tracking,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($result, true);

        $output = '';
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .trim(end($data['data']['history'])['description']). '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data['data']['history'] as $status) {
            $output.=   '<tr>';
            $output.=   '<td>' .date('d-m-Y', $status['date']). '</td>';                 
            $output.=   '<td>' .$status['description']. '</td>';
            $output.=   '<td>' .$status['status']. '</td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';
        echo $output;
    }



// OSHI COURIER
    else if ($courier == 'Oshi Courier') {

        $dvs_oshi_code = get_option('dvs_oshi_code');
        $dvs_oshi_api = get_option('dvs_oshi_api');

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://oshicourier.pk/trackingapiv2',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
            "clients": "'.$dvs_oshi_code.'",
            "token": "'.$dvs_oshi_api.'",
            "shipped_ref": "'.$tracking.'"
        }',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response, true);

        if (isset($data[0]['status'])) {
            $current_status = end($data)['status'];
            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .$status['createdon']. '</td>';
                $output.=   '<td>' .$status['status']. '</td>';
                $output.=   '<td></td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }



// COVERED LOGISTICS
    else if ($courier == 'Covered Logistics') {

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.covered.pk/api/v1/booking/trackParcel?cn='.$tracking,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($result, true);

        $current_status = trim($data['data']['currentStatus']);

        $output = '';
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data['data']['statesUpdates'] as $status) {
            $output.=   '<tr>';
            $output.=   '<td>' .$status['timestamps']. '</td>';
            $output.=   '<td>' .$status['status']. '</td>';
            $output.=   '<td>' .$status['by']. '</td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';
        echo $output;
    }



// COURIERS NEXT
    else if ($courier == 'Couriers Next') {

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://portal.couriersnext.com/API/TrackOrder.php',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{"tracking_no": "'.$tracking.'"}',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response, true);

        if (!empty($data)) {

            $data = json_decode($response, true);

            $current_status = trim(end($data)['status']);

            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data as $a) {
                $output.=   '<tr>';
                $output.=   '<td>' .$a['created']. '</td>';                       
                $output.=   '<td>' .$a['status']. '</td>';
                $output.=   '<td></td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }



// BARQ RAFTAR
    else if ($courier == 'Barq Raftar') {

        $dvs_barqraftar_api = get_option( 'dvs_barqraftar_api' );
        $dvs_barqraftar_secret = get_option( 'dvs_barqraftar_secret' );

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://barqraftar.pk/api/v1/order/?tracking_number='.$tracking,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'key: '.$dvs_barqraftar_api,
            'secret: '.$dvs_barqraftar_secret,
        ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response, true);

       if($data['status'] == 'success') {

            $data = json_decode($response, true);

            $current_status = end($data['order']['status_logs'])['status_value'];

            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data['order']['status_logs'] as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .substr($status['created_at'], 0, 16). '</td>';                    
                $output.=   '<td>' .$status['status_value'].'</td>';
                $output.=   '<td></td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }






// ZAAF COURIER
    else if ($courier == 'Zaaf Courier') {

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://zaaf.pk/API/TrackOrder.php',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{"tracking_no": "'.$tracking.'"}',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response, true);

        if ($data['message'] == "SUCCESS") {

            $data = json_decode($response, true);

            $current_status = trim(end($data['delivery_info'])['status']);

            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
            $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
            foreach ($data['delivery_info'] as $status) {
                $output.=   '<tr>';
                $output.=   '<td>' .$status['datetime']. '</td>';                       
                $output.=   '<td>' .$status['status']. '</td>';
                $output.=   '<td></td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }





    // ACTIVE COURIER
    else if ($courier == 'Bouraq Express') {

        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://bouraqcod.com/portal/API/TrackOrder.php',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{"tracking_no": "'.$tracking.'"}',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
            ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($result, true);

        $output = '';
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .trim(end($data)['status']). '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data as $a) {
            $output.=   '<tr>';
            $output.=   '<td>' .$a['created']. '</td>';                       
            $output.=   '<td>' .$a['status']. '</td>';
            $output.=   '<td></td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';
        echo $output;
    }




// ACTIVE COURIER
    else if ($courier == 'Active Courier') {

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://panel.activecourier.pk/API/TrackOrder.php',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{"tracking_no": "'.$tracking.'"}',
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
            ),
        ));
        $result = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($result, true);

        $output = '';
        $output.=   '<div class="order-details">';                       
        $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
        $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
        
        $output.=   '</div>';
        $output.=   '<div class="tracking-details">';                       
        $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
        $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
        $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
        $output.=   '</div>'; 
        $output.=   '<div class="status"><strong>Current Status: </strong>' .trim(end($data)['status']). '</div>';
        $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';
        foreach ($data as $a) {
            $output.=   '<tr>';
            $output.=   '<td>' .$a['created']. '</td>';                       
            $output.=   '<td>' .$a['status']. '</td>';
            $output.=   '<td></td>';
            $output.=   '</tr>';                            
        }             
        $output.=   '</table>';
        echo $output;
    }





// SHIP NOC
    else if ($courier == 'Ship NOC') {
        
        $shipper_api = get_option('dvs_noc_username');
        $shipper_code = get_option('dvs_noc_password');

        $shipper_username = urlencode($shipper_api);
        $shipper_password = urlencode($shipper_code);
        
        $noc_signature = $shipper_api . $shipper_code . "noc@#";
        $noc_signature = urlencode($noc_signature);
                
        $noc_track_url = 'http://api.shipnoc.com/api/GetParcelTracking?UserName=' . $shipper_username . '&Password=' . $shipper_password . '&Signature=' . $noc_signature . '&ParcelNo=' . $tracking;

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => $noc_track_url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 10,  
          CURLOPT_SSL_VERIFYPEER => false,
          CURLOPT_SSL_VERIFYHOST => false,                    
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'Accept: application/json'
          ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        $data = json_decode($response, true);

        if ($data['Response'] == "success") {

            $current_status = $data['detail'][0]['PacelStatus'];
            
            if(empty($current_status)) {
                $current_status = 'Booked';
            }

            $output = '';
            $output.=   '<div class="order-details">';                       
            $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
            $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
            $output.=   '<div class="phone"><strong>Phone: </strong>' .$order->get_billing_phone(). '</div>';
            $output.=   '</div>';
            $output.=   '<div class="tracking-details">';                       
            $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
            $output.=   '<div class="tracking"><strong>Tracking: </strong><a href="https://one.instaworld.pk/track" target="blank">' .$tracking. '</a></div>';
            $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
            $output.=   '</div>'; 
            $output.=   '<div class="status"><strong>Current Status: </strong>' .$current_status. '</div>';
            $output.=   '<table><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

            foreach ($data['detail'] as $a) {
                $output.=   '<tr>';
                $output.=   '<td>' .$a['DateTime']. '</td>';                       
                $output.=   '<td>' .$a['PacelStatus']. '</td>';
                $output.=    '<td>' .$a['Remarks']. '</td>';
                $output.=   '</tr>';                            
            }             
            $output.=   '</table>';
        }
        else {
            $output = 'Status: No result found';
        }
        echo $output;
    }



// RAPID COURIER    
    // else if ($courier == 'Rapid Courier') {
    //     $rcs_api = get_option('dvs_rcs_shipper_api');
    //     $dvs_rapid_courier_url = 'https://app.couriermanager.eu/cscourier/API/get_info?api_key='.$rcs_api.'&awbno='.$tracking;
    //     $curl = curl_init();
    //     curl_setopt($curl, CURLOPT_URL, $dvs_rapid_courier_url);
    //     curl_setopt($curl,CURLOPT_RETURNTRANSFER, true);
    //     $response = curl_exec($curl);
    //     curl_close($curl);
    //     $data = json_decode($response, true);

    //     $output = '';        
    //     $output.=   '<div class="order-details">';                       
    //     $output.=   '<div class="order"><strong>Order: </strong>' .$order->get_order_number(). '</div>';
    //     $output.=   '<div class="name"><strong>Name: </strong>' .$order->get_billing_first_name(). '</div>';
    //     
    //     $output.=   '</div>';
    //     $output.=   '<div class="tracking-details">';                       
    //     $output.=   '<div class="courier"><strong>Courier: </strong>' .$courier. '</div>';
    //     $output.=   '<div class="tracking"><strong>Tracking: </strong>' .$tracking. '</div>';
    //     $output.=   '<div class="city"><strong>Destination: </strong>' .$order->get_billing_city(). '</div>';
    //     $output.=   '</div>'; 
    //     $output.=   '<div class="status"><strong>Current Status: </strong>' .end($data)['ProcessDescForPortal']. '</div>';
    //     $output.=   '<table class="dvs-track-box-table"><tr><th>Time</th><th>Status</th><th>Comments</th></tr>';

    //     foreach ($data as $a) {
    //         $output.=   '<tr>';
    //         $output.=   '<td>' .$a['TransactionDate']. '</td>';                       
    //         $output.=   '<td>' .$a['ProcessDescForPortal']. '</td>';
    //         $output.=   '<td>' .$a['OperationDesc']. ' ' .$a['ReceiverName'].'</td>';
    //         $output.=   '</tr>';                            
    //     }             
    //     $output.=   '</table>';            
    //     echo $output;
    // }
    // else if ($courier == 'DCS Courier') {
    //     $dvs_tracking_link = "http://dcscourier.com/Tracking";
    //     echo '<div class="dvs-100">';
    //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
    //     echo '</div>';
    // }
    // else if ($courier == 'Pace Courier') {
    //     $dvs_tracking_link = "https://pacecourierservice.com/tracking.php";
    //     echo '<div class="dvs-100">';
    //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
    //     echo '</div>';
    // }   
    // else if ($courier == 'Pakistan Post') {
    //     $dvs_tracking_link = "http://ep.gov.pk/";
    //     echo '<div class="dvs-100">';
    //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
    //     echo '</div>';
    // }
    // else if ($courier == 'DHL') {
    //     $output = '';
    //     $dvs_tracking_link = "https://www.dhl.com/en/express/tracking.html?AWB=".$tracking."&brand=DHL";
    //     $output.= '<div class="dvs-100">';
    //     $output.= '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
    //     $output.= '</div>';
    //     echo $output;        
    // }
    // else if ($courier == 'FedEx') {
    //     $dvs_tracking_link = "https://www.fedex.com/apps/fedextrack/?action=track";
    //     echo '<div class="dvs-100">';
    //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
    //     echo '</div>';
    // }
    // else if ($courier == 'SkyNet') {
    //     $dvs_tracking_link = "https://sky.skynet.net/public/Tracking.aspx?guide=".$tracking."";
    //     echo '<div class="dvs-100">';
    //     echo '<a href="'.$dvs_tracking_link.'" target="blank" rel="no-follow" class="dvs-tracking-btn">View Live Tracking</a>';
    //     echo '</div>';
    // }      
    else {
        echo 'Tracking Not Available';
    }
    ?>
    </div>
</div>
<?php    
    }
	echo '</div>';

do_action( 'woocommerce_view_order', $order->get_id() ); ?>